//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// dwuwymiarowe wsprzdne punktw kontrolnych krzywej Bziera
//////////////////////////////////////////////////////////////////////
uniform vec2 points[4];

//////////////////////////////////////////////////////////////////////
// liczba generowanych odcinkw krzywej
//////////////////////////////////////////////////////////////////////
uniform int segments = 50;

//////////////////////////////////////////////////////////////////////
// macierz bazowa wspczynnikw rwnania krzywej Bziera
//////////////////////////////////////////////////////////////////////
mat4 base = mat4( -1.0, 3.0, -3.0, 1.0,
                   3.0, -6.0, 3.0, 0.0,
                  -3.0, 3.0, 0.0, 0.0,
                   1.0, 0.0, 0.0, 0.0 );

//////////////////////////////////////////////////////////////////////
// macierz utworzona ze wsprzdnych punktw
// kontrolnych rwnania krzywej Bziera
//////////////////////////////////////////////////////////////////////
mat4 m = mat4( points[0], 0.0, 1.0,
               points[1], 0.0, 1.0,
               points[2], 0.0, 1.0,
               points[3], 0.0, 1.0 );

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // wybrany parametr rwnania krzywej Bziera
    float t = (gl_InstanceID + gl_VertexID) / (segments - 1.0);

    // wektor wspczynnikw rwnania krzywej Bziera
    vec4 tvec = vec4( t*t*t, t*t, t, 1 );

    // obliczenie wsprzdnych punktu krzywej
    // i przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * m * base * tvec;
}
