//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// wektory przesuni poszczeglnych instancji obiektu
//////////////////////////////////////////////////////////////////////
const vec4 positions[5] = vec4[5]
(
    vec4( 2.5, 2.5, 0.0, 0.0 ),
    vec4( -2.5, 2.5, 0.0, 0.0 ),
    vec4( -2.5, -2.5, 0.0, 0.0 ),
    vec4( 2.5, -2.5, 0.0, 0.0 ),
    vec4( 0.0, 0.0, 0.0, 0.0 )
);

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0
#define NORMAL 1

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
layout( location = NORMAL ) in vec3 inNormal;

//////////////////////////////////////////////////////////////////////
// blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec3 position;

    // wsprzdne wektora normalnego
    vec3 normal;

    // numer obiektu
    int object;
} Out;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * (inPosition + positions[gl_InstanceID]);

    // wsprzdne wierzchoka do interpolacji
    Out.position = (inPosition + positions[gl_InstanceID]).xyz;

    // wsprzdne wektora normalnego do interpolacji
    Out.normal = inNormal;

    // numer obiektu
    Out.object = gl_InstanceID;
}
