//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat left;
extern GLfloat right;
extern GLfloat bottom;
extern GLfloat top;
extern GLfloat rotateX;
extern GLfloat rotateY;
extern int spriteCount;
extern GLfloat pointSize;

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// pooenie kursora myszy
//////////////////////////////////////////////////////////////////////
int buttonX, buttonY;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // zapamitanie pooenia kursora myszy
        if( state == GLUT_DOWN )
        {
            buttonX = x;
            buttonY = y;
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        rotateY += 30 *(right - left) / glutGet( GLUT_WINDOW_WIDTH ) * (x - buttonX);
        buttonX = x;
        rotateX -= 30 *(top - bottom) / glutGet( GLUT_WINDOW_HEIGHT ) * (buttonY - y);
        buttonY = y;
        glutPostRedisplay();
    }
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // liczba sprajtw
    SPRITE_1000,
    SPRITE_2000,
    SPRITE_3000,
    SPRITE_4000,
    SPRITE_5000,
    SPRITE_6000,
    SPRITE_7000,
    SPRITE_8000,
    SPRITE_9000,
    SPRITE_10000,
    SPRITE_11000,
    SPRITE_12000,
    SPRITE_13000,
    SPRITE_14000,
    SPRITE_15000,
    SPRITE_16000,
    SPRITE_17000,
    SPRITE_18000,
    SPRITE_19000,
    SPRITE_20000,

    EXIT    // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // liczba sprajtw
        case SPRITE_1000:
        case SPRITE_2000:
        case SPRITE_3000:
        case SPRITE_4000:
        case SPRITE_5000:
        case SPRITE_6000:
        case SPRITE_7000:
        case SPRITE_8000:
        case SPRITE_9000:
        case SPRITE_10000:
        case SPRITE_11000:
        case SPRITE_12000:
        case SPRITE_13000:
        case SPRITE_14000:
        case SPRITE_15000:
        case SPRITE_16000:
        case SPRITE_17000:
        case SPRITE_18000:
        case SPRITE_19000:
        case SPRITE_20000:
            spriteCount = 1000 * (value + 1);
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // klawisz +
        case '+':
            pointSize += 0.2f;
            break;
        // klawisz -
        case '-':
            if( pointSize > 0.2f ) pointSize -= 0.2f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiszy funkcyjnych i klawiszy kursora
//////////////////////////////////////////////////////////////////////
void SpecialKeys( int key, int x, int y )
{
    switch( key )
    {
        case GLUT_KEY_PAGE_DOWN:
            if( spriteCount < 20000 ) spriteCount += 1000;
            break;
        case GLUT_KEY_PAGE_UP:
            if( spriteCount > 1000 ) spriteCount -= 1000; 
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 3, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
#ifdef WIN32
    glutCreateWindow( "nieg" );
#else
    glutCreateWindow( "Snieg" );
#endif // WIN32

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_3_3 )
    {
        std::cout << "Brak OpenGL 3.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu - Liczba instancji
    int menuSpriteCount = glutCreateMenu( Menu );
    glutAddMenuEntry( "1000", SPRITE_1000 );
    glutAddMenuEntry( "2000", SPRITE_2000 );
    glutAddMenuEntry( "3000", SPRITE_3000 );
    glutAddMenuEntry( "4000", SPRITE_4000 );
    glutAddMenuEntry( "5000", SPRITE_5000 );
    glutAddMenuEntry( "6000", SPRITE_6000 );
    glutAddMenuEntry( "7000", SPRITE_7000 );
    glutAddMenuEntry( "8000", SPRITE_8000 );
    glutAddMenuEntry( "9000", SPRITE_9000 );
    glutAddMenuEntry( "10000", SPRITE_10000 );
    glutAddMenuEntry( "11000", SPRITE_11000 );
    glutAddMenuEntry( "12000", SPRITE_12000 );
    glutAddMenuEntry( "13000", SPRITE_13000 );
    glutAddMenuEntry( "14000", SPRITE_14000 );
    glutAddMenuEntry( "15000", SPRITE_15000 );
    glutAddMenuEntry( "16000", SPRITE_16000 );
    glutAddMenuEntry( "17000", SPRITE_17000 );
    glutAddMenuEntry( "18000", SPRITE_18000 );
    glutAddMenuEntry( "19000", SPRITE_19000 );
    glutAddMenuEntry( "20000", SPRITE_20000 );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddSubMenu( "Liczba czastek", menuSpriteCount );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // obsuga klawiszy funkcyjnych i klawiszy kursora
    glutSpecialFunc( SpecialKeys );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // doczenie funkcji wywoywanej przy bezczynnoci programu
    glutIdleFunc( Display );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
