#version 440 core

#extension GL_ARB_shader_draw_parameters : require

// Wejścia dla każdego wierzchołka.
layout (location = 0) in vec4 position;
layout (location = 1) in vec3 normal;
layout (location = 4) in vec2 tc;

struct MATRICES
{
    mat4 modelview;
    mat4 projection;
};

// Potrzebne macierze.
layout (binding = 0, std140) uniform constants
{
    MATRICES matrices[16];
};

// Wyjścia z shadera wierzchołków.
out VS_OUT
{
    vec3 N;
    vec3 L;
    vec3 V;
    vec2 tc;
} vs_out;

// Położenie światła.
const vec3 light_pos = vec3(100.0, 100.0, 100.0);

void main(void)
{
    mat4 mv_matrix = matrices[gl_BaseInstanceARB].modelview;
    mat4 proj_matrix = matrices[gl_BaseInstanceARB].projection;

    // Oblicz współrzędne w przestrzeni widoku.
    vec4 P = mv_matrix * position;

    // Oblicz normalne w przestrzeni widoku.
    vs_out.N = mat3(mv_matrix) * normal;

    // Oblicz wektor światła.
    vs_out.L = light_pos - P.xyz;

    // Oblicz wektor widoku.
    vs_out.V = -P.xyz;

    // Przekaż współrzędne tekstury.
    vs_out.tc = tc * vec2(5.0, 1.0);

    // Oblicz położenie w przestrzeni przycięcia dla każdego wierzchołka.
    gl_Position = proj_matrix * P;
}
