#version 410 core

// Wejcia per wierzchoek.
layout (location = 0) in vec4 position;
layout (location = 1) in vec3 normal;

// Niezbdne macierze.
layout (std140) uniform constants
{
    mat4 mv_matrix;
    mat4 view_matrix;
    mat4 proj_matrix;
};

// Wyjcia z shadera wierzchokw.
out VS_OUT
{
    vec3 N;
    vec3 L;
    vec3 V;
} vs_out;

// Pooenie wiata.
uniform vec3 light_pos = vec3(100.0, 100.0, 100.0);

void main(void)
{
    // Obliczenie wsprzdnych w przestrzeni widoku.
    vec4 P = mv_matrix * position;

    // Obliczenie normalnej w przestrzeni widoku.
    vs_out.N = mat3(mv_matrix) * normal;

    // Obliczenie wektora owietlenia.
    vs_out.L = light_pos - P.xyz;

    // Obliczenie wektora widoku.
    vs_out.V = -P.xyz;

    // Obliczenie pooenia kadego wierzchoka w przestrzeni przycicia.
    gl_Position = proj_matrix * P;
}
