#version 420 core

out vec4 color;

// Mapy koloru i normalnych.
layout (binding = 0) uniform sampler2D tex_color;
layout (binding = 1) uniform sampler2D tex_normal;

in VS_OUT
{
    vec2 texcoord;
    vec3 eyeDir;
    vec3 lightDir;
    vec3 normal;
} fs_in;

void main(void)
{
    // Znormalizuj otrzymane wektory widoku i wiata.
    vec3 V = normalize(fs_in.eyeDir);
    vec3 L = normalize(fs_in.lightDir);
    // Odczytaj normaln z mapy normalnych i znormalizuj j.
    vec3 N = normalize(texture(tex_normal, fs_in.texcoord).rgb * 2.0 - vec3(1.0));
    // Usu komentarz, aby zastosowa standardowe normalne zamiast mapy normalnych.
    N = vec3(0.0, 0.0, 1.0);
    // Oblicz R, aby mc stosowa owietlenie Phonga.
    vec3 R = reflect(-L, N);

    // Pobierz albedo rozproszenia z tekstury.
    vec3 diffuse_albedo = texture(tex_color, fs_in.texcoord).rgb;
    // Oblicz kolor rozproszenia przez iloczyn N i L.
    vec3 diffuse = max(dot(N, L), 0.0) * diffuse_albedo;
    // Usu komentarza, aby wyczy cieniowanie wiatem rozproszonym.
    diffuse = vec3(0.0);

    // Zamy, e albedo wiata odbitego to biel; warto rwnie mogaby pochodzi z tekstury.
    vec3 specular_albedo = vec3(1.0);
    // Oblicz rozbysk Phonga dotyczcy odbicia wiata.
    vec3 specular = max(pow(dot(R, V), 5.0), 0.0) * specular_albedo;
    // Usu komentarza, aby wyczy rozbysk.
    specular = vec3(0.0);

    // Ostateczny kolor to poczenie kolorw rozproszenia i odbicia.
    color = vec4(diffuse + specular, 1.0);
}
