#version 420 core

layout (binding = 0) uniform sampler3D tex_envmap;
layout (binding = 1) uniform sampler2D tex_glossmap;

in VS_OUT
{
    vec3 normal;
    vec3 view;
    vec2 tc;
} fs_in;

out vec4 color;

void main(void)
{
    // Zmienna u to znormalizowany wektor widoku.
    vec3 u = normalize(fs_in.view);

    // Odbij u względem płaszczyzny zdefiniowanej przez normalną w miejscu fragmentu.
    vec3 r = reflect(u, normalize(fs_in.normal));

    // Oblicz współczynnik skali.
    r.z += 1.0;
    float m = 0.5 * inversesqrt(dot(r, r));

    // Próbka współczynnika gładkości od tekstury mapy gładkości.
    float gloss = texture(tex_glossmap, fs_in.tc * vec2(3.0, 1.0) * 2.0).r;

    // Próbka na podstawie przesuniętej i przeskalowanej współrzędnej tekstury.
    vec3 env_coord = vec3(r.xy * m + vec2(0.5), gloss);

    // Próbka z dwupoziomowej mapy środowiska.
    color = texture(tex_envmap, env_coord);
}
