#version 430 core

layout (location = 0) out vec4 color;

layout (binding = 0) uniform sampler2D tex;

in VS_OUT
{
    vec2 tc;
} fs_in;

vec4 hqfilter(sampler2D samp, vec2 tc)
{
    // Pobierz rozmiar tekstury poddawanej prbkowaniu.
    vec2 texSize = textureSize(tex, 0);

    // Przeskaluj wsprzdne tekstury w gr i przesu na rodek teksela.
    vec2 uvScaled = tc * texSize + 0.5;

    // Znajd cz cakowit i uamkow wsprzdnej tekstury.
    vec2 uvInt = floor(uvScaled);
    vec2 uvFrac = fract(uvScaled);

    // Zastp cz uamkow wsprzdnej tekstury.
    uvFrac = smoothstep(0.0, 1.0, uvFrac);

    // Powr do poprzedniego zakresu, usuwajc przesunicie
    // skalujc ponownie do zakresu od 0,0 do 1,0.
    vec2 uv = (uvInt + uvFrac - 0.5) / texSize;

    // Zastosuj standardowe pobranie prbki.
    return texture(samp, uv);
}

void main(void)
{
    color = texture(tex, fs_in.tc / 8.0);
    color = hqfilter(tex, fs_in.tc / 8.0);
}
