
#version 420 core

layout (location = 0) out vec4 color0;
layout (location = 1) out vec4 color1;

in VS_OUT
{
    vec3 N;
    vec3 L;
    vec3 V;
    flat int material_index;
} fs_in;

// Waciwoci materiau.
uniform float bloom_thresh_min = 0.8;
uniform float bloom_thresh_max = 1.2;

struct material_t
{
    vec3    diffuse_color;
    vec3    specular_color;
    float   specular_power;
    vec3    ambient_color;
};

layout (binding = 1, std140) uniform MATERIAL_BLOCK
{
    material_t  material[32];
} materials;

void main(void)
{
    // Normalizacja wektorw wejciowych N, L i V.
    vec3 N = normalize(fs_in.N);
    vec3 L = normalize(fs_in.L);
    vec3 V = normalize(fs_in.V);

    // Obliczenie R w sposb lokalny.
    vec3 R = reflect(-L, N);

    material_t m = materials.material[fs_in.material_index];

    // Obliczenie komponentw odbicia rozmytego i lustrzanego dla kadego fragmentu.
    vec3 diffuse = max(dot(N, L), 0.0) * m.diffuse_color;
    vec3 specular = pow(max(dot(R, V), 0.0), m.specular_power) * m.specular_color;
    vec3 ambient = m.ambient_color;

    // Dodanie skadnika koloru otoczenia, rozmycia i odbicia lustrzanego w celu uzyskania finalnego koloru.
    vec3 color = ambient + diffuse + specular;

    // Zapis koloru w buforze ramki.
    color0 = vec4(color, 1.0);

    // Obliczenie luminancji.
    float Y = dot(color, vec3(0.299, 0.587, 0.144));

    // Kolor progu bazuje na luminancji i zapisuje go do drugiego wyjcia koloru.
    color = color * 4.0 * smoothstep(bloom_thresh_min, bloom_thresh_max, Y);
    color1 = vec4(color, 1.0);
}