#version 430 core

layout (binding = 0) uniform sampler2D input_image;

layout (location = 0) out vec4 color;

uniform float focal_distance = 50.0;
uniform float focal_depth = 30.0;

void main(void)
{
    // Zmienna s służy do przeskalowania współrzędnych tekstury przed 
    // pobraniem danych z obrazu tablicy zsumowanego obszaru.
    vec2 s = 1.0 / textureSize(input_image, 0);
    // Zmienna C to środek filtra.
    vec2 C = gl_FragCoord.xy;

    // Najpierw pobieramy wartość tabeli w środku filtra, ponieważ
    // ostatni kanał przechowuje głębię piksela w przestrzeni widoku.
    vec4 v = texelFetch(input_image, ivec2(gl_FragCoord.xy), 0).rgba;

    // Zmienna m to promień filtra.
    float m;

    // W tej aplikacji obraz głębi jest wyzerowany przez rozpoczęciem renderowania,
    // więc jeśli nadal wynosi 0, nie renderowaliśmy w tym miejscu.
    // Ustawiamy w takim razie promień na 0,5 (czyli średnicę 1,0) i idziemy dalej.
    if (v.w == 0.0)
    {
        m = 0.5;
    }
    else
    {
        // Obliczenie krążka rozmycia.
        m = abs(v.w - focal_distance);

        // Proste gładkie skalowanie i przesunięcie. Minimalny promień
        // wynosi 0,5 (średnica 1,0), maksymalny 8,0. Obszar filtru prostokątnego
        // większy niż 16 pikseli nie wygląda zbyt ciekawie.
        m = 0.5 + smoothstep(0.0, focal_depth, m) * 7.5;
    }

    // Obliczenie położenia czterech wierzchołków
    // definiujących obszar próbkowania.
    vec2 P0 = vec2(C * 1.0) + vec2(-m, -m);
    vec2 P1 = vec2(C * 1.0) + vec2(-m, m);
    vec2 P2 = vec2(C * 1.0) + vec2(m, -m);
    vec2 P3 = vec2(C * 1.0) + vec2(m, m);

    // Przeskalowanie współrzędnych.
    P0 *= s;
    P1 *= s;
    P2 *= s;
    P3 *= s;

    // Pobranie wartości z czterech narożników.
    vec3 a = textureLod(input_image, P0, 0).rgb;
    vec3 b = textureLod(input_image, P1, 0).rgb;
    vec3 c = textureLod(input_image, P2, 0).rgb;
    vec3 d = textureLod(input_image, P3, 0).rgb;

    // Obliczenie sumy wszystkich pikseli wewnątrz prostokąta.
    vec3 f = a - b - c + d;

    // Skalowanie promień -> średnica.
    m *= 2;

    // Dzielenie przez obszar.
    f /= float(m * m);

    // Przekazanie finalnego koloru.
    color = vec4(f, 1.0);
}
