#version 410 core

// Wejcia per wierzchoek.
layout (location = 0) in vec4 position;
layout (location = 1) in vec3 normal;

// Niezbdne macierze.
layout (std140) uniform constants
{
    mat4 mv_matrix;
    mat4 view_matrix;
    mat4 proj_matrix;
};

// Waciwoci wiata i materiau.
uniform vec3 light_pos = vec3(100.0, 100.0, 100.0);
uniform vec3 diffuse_albedo = vec3(0.5, 0.2, 0.7);
uniform vec3 specular_albedo = vec3(0.7);
uniform float specular_power = 128.0;
uniform vec3 ambient = vec3(0.1, 0.1, 0.1);

// Wyjcia shadera fragmentw.
out VS_OUT
{
    vec3 color;
} vs_out;

void main(void)
{
    // Obliczenie wsprzdnych w przestrzeni widoku.
    vec4 P = mv_matrix * position;

    // Obliczenie normalnej w przestrzeni widoku.
    vec3 N = mat3(mv_matrix) * normal;
    // Obliczenie wektora wiata w przestrzeni widoku.
    vec3 L = light_pos - P.xyz;
    // Obliczenie wektora widoku (negacja pooenia w przestrzeni widoku).
    vec3 V = -P.xyz;

    // Normalizacja wszystkich trzech wektorw.
    N = normalize(N);
    L = normalize(L);
    V = normalize(V);

    // Obliczenie R przez odbicie -L wzgldem paszczyzny zdefiniowanej przez N.
    vec3 R = reflect(-L, N);

    // Obliczenie wspczynnikw rozproszenia i odbicia.
    vec3 diffuse = max(dot(N, L), 0.0) * diffuse_albedo;
    vec3 specular = pow(max(dot(R, V), 0.0), specular_power) * specular_albedo;

    // Wysanie wynikowego koloru do shadera fragmentw.
    vs_out.color = ambient + diffuse + specular;

    // Obliczenie pooenia kadego wierzchoka w przestrzeni przycicia.
    gl_Position = proj_matrix * P;
}
