#version 410 core

// Wejścia dla każdego wierzchołka.
layout (location = 0) in vec4 position;
layout (location = 1) in vec3 normal;

/*
// Potrzebne macierze.
layout (std140) uniform constants
{
    mat4 mv_matrix;
    mat4 view_matrix;
    mat4 proj_matrix;
};
*/

uniform mat4 mv_matrix;
uniform mat4 proj_matrix;

// Wyjścia z shadera wierzchołków.
out VS_OUT
{
    vec3 N;
    vec3 L;
    vec3 V;
} vs_out;

// Położenie światła.
uniform vec3 light_pos = vec3(100.0, 100.0, 100.0);

// Płaszczyzna przycięcia.
uniform vec4 clip_plane = vec4(1.0, 1.0, 0.0, 0.85);
uniform vec4 clip_sphere = vec4(0.0, 0.0, 0.0, 4.0);

void main(void)
{
    // Oblicz współrzędne w przestrzeni widoku.
    vec4 P = mv_matrix * position;

    // Oblicz normalne w przestrzeni widoku.
    vs_out.N = mat3(mv_matrix) * normal;

    // Oblicz wektor światła.
    vs_out.L = light_pos - P.xyz;

    // Oblicz wektor widoku.
    vs_out.V = -P.xyz;

    // Zapisz odległości przycięcia.
    gl_ClipDistance[0] = dot(position, clip_plane);
    gl_ClipDistance[1] = length(position.xyz / position.w - clip_sphere.xyz) - clip_sphere.w;

    // Oblicz położenie w przestrzeni przycięcia dla każdego wierzchołka.
    gl_Position = proj_matrix * P;
}
