//Exercises_10_5.cpp ćwiczenia z końca rozdziału 10
#include <opencv2/opencv.hpp>
#include <iostream>

using namespace cv;
using namespace std;

 
void help(const char **argv) {
	cout << "\n\n"
		<< "Ten program rozwiązuje ćwiczenie 5 z końca rozdziału 10.\n"
		<< "Wywołanie:\n"
		<< argv[0] << " <path/image_name1>" << " <path/image_name2>\n\n"
		<< "Na przykład: ./" << argv[0] << " ../left.jpg "<< " ../left.jpg\n"
		<< endl;
}

int main( int argc, const char** argv )
{
	help(argv);
	if(argc < 3) {
		cout << "\nBłąd: za mało parametrów.\n" << endl;
		return -1;
	}
	Mat temp;
	Mat temp2;
 /************************************************************************/
	/* 5.	Utwórz obrys obiektu. Zrób zdjęcie sceny. Następnie, nie ruszając aparatem, postaw filiżankę kawy przed obiektywem i zrób drugie zdjęcie. Załaduj te zdjęcia do komputera i przekonwertuj je na 8-bitowe obrazy w skali szarości.
a.	Oblicz wartość bezwzględną różnicy tych dwóch obrazów. Wyświetl wynik, który powinien przedstawiać niewyraźną filiżankę kawy.
b.	Obetnij wartości otrzymanego obrazu do progu, który pozwoli zachować większość filiżanki, ale usunie część zakłóceń. Wyświetl wynik. Wartości „włączone” powinny być ustawione na 255.
c.	Wykonaj operację cv::MOP_OPEN na obrazie, aby jeszcze lepiej wyczyścić go z zakłóceń.
d.	Za pomocą operatora erozji i logicznej funkcji XOR zamień maskę obrazu filiżanki kawy w obrys tej filiżanki (powinien zawierać tylko piksele krawędziowe).                                                                     */
	/************************************************************************/
	Mat matMug = imread(argv[1],IMREAD_GRAYSCALE);
	Mat matNoMug = imread(argv[2],IMREAD_GRAYSCALE);
	if (matMug.empty() || matNoMug.empty())
	{
		cout << "\nBłąd: parametr nie jest nazwą obrazu.\n" << endl;
		return -1;
	}
	//a
	absdiff(matMug,matNoMug,temp);
	imshow("bezwzględna wartość mug ",temp);
	//b
	threshold(temp,temp,100,255,THRESH_OTSU);
	imshow("próg binarny",temp);
	//c
	morphologyEx(temp,temp,cv::MORPH_OPEN,Mat());
	imshow("MORPH_OPEN",temp);
	//d
	erode(temp,temp,Mat());
	matMug.copyTo(temp2,temp);
	imshow("obrys kubka kawy",temp2);
	waitKey();
	return 0;

}
