// Listing 8.1. Odpakowywanie czteroznakowego kodu identyfikujcego kodek wideo
//
//#include <opencv2/opencv.hpp>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <iostream>

using namespace std;
void help(char** argv ) {
	cout << "\n"
	<< "Listing 8.1. Odpakowywanie czteroznakowego kodu identyfikujcego kodek wideo"
  << "\nWywoanie:\n"
	<< argv[0] <<" <path/video>\n"
	<< "Na przykad:\n"
	<< argv[0] << " ../tree.avi\n"
	<< endl;
}
	

int main( int argc, char** argv ) {
	
	if (argc != 2) {
		help(argv);
		return 0;
	}


  cv::VideoCapture cap( argv[1] );

  unsigned f = (unsigned)cap.get( cv::CAP_PROP_FOURCC );

  char fourcc[] = {
	  (char) f,        // pierwszy znak dotyczy najniszych bitw
	  (char)(f >> 8),  // drugi znak dotyczy bitw 8  15
	  (char)(f >> 16), // nastpny znak dotyczy bitw 16  23
	  (char)(f >> 24), // ostatni znak dotyczy bitw 24  31
	  '\0'             // nie zapomnij o zakoczeniu tablicy
  };

  cout <<"FourCC dla tego wideo: " <<fourcc <<endl;




}
