// Listing 4.3. Drukowanie wszystkich niezerowych elementw tablicy rzadkiej

#include <opencv2/opencv.hpp>
#include <iostream>

// Drukowanie wszystkich niezerowych elementw tablicy rzadkiej
//
using namespace std;

// Sumowanie elementw tablicy wielowymiarowej paszczyzna po paszczynie
//
int main( int argc, char** argv ) {
  
  cout << "\nListing 4.3. Drukowanie wszystkich niezerowych elementw tablicy rzadkiej"
       << "\nWywoanie:\n" << argv[0] << endl;

  // utworzenie rzadkiej macierzy o wymiarach 1010 z kilkoma niezerowymi elementami
  //
  int size[] = {10,10};
  cv::SparseMat sm( 2, size, CV_32F );
  for( int i=0; i<10; i++ ) { // zapenienie tablicy
    int idx[2];
    idx[0] = size[0] * rand();
    idx[1] = size[1] * rand();
    sm.ref<float>( idx ) += 1.0f;
  }

  // drukowanie niezerowych elementw
  //
  cv::SparseMatConstIterator_<float> it = sm.begin<float>();
  cv::SparseMatConstIterator_<float> it_end = sm.end<float>();

  for(; it != it_end; ++it) {
    const cv::SparseMat::Node* node = it.node();
    printf(" (%3d,%3d) %f\n", node->idx[0], node->idx[1], *it );
  }

}
