#include <opencv2/opencv.hpp>
#include <iostream>

using namespace std;

void help(argv) {

	cout << "\n"
		<< "Przykad uycia funkcji matchTemplate(). Wywoanie:\n"
		<< "\n"
		<< argv[0] << " szablon obraz do przeszukania\n"
		<< "\n"
		<< " Ta procedura szuka przy uyciu wszystkich metod:\n"
		<< " cv::TM_SQDIFF 0\n"
		<< " cv::TM_SQDIFF_NORMED 1\n"
		<< " cv::TM_CCORR 2\n"
		<< " cv::TM_CCORR_NORMED 3\n"
		<< " cv::TM_CCOEFF 4\n"
		<< " cv::TM_CCOEFF_NORMED 5\n"
		<< "\n";
}

// wywietlenie wynikw dopasowywania
//
int main(int argc, char** argv) {

	if (argc != 3) {
		help(argv);
		return -1;
	}

	cv::Mat src, templ, ftmp[6]; // na ftmp bdzie wywietlany wynik

								 // wczytanie szablonu do dopasowywania
								 //
	if ((templ = cv::imread(argv[1], 1)).empty()) {
		cout << "Bd wczytywania szablonu " << argv[1] << endl;
		help(argv); return -1;
	}

	// wczytanie obrazu rdowego do przeszukania
	//
	if ((src = cv::imread(argv[2], 1)).empty()) {
		cout << "Bd wczytywania obrazu rdowego " << argv[2] << endl;
		help(argv); return -1;
	}

	// szukanie szablonu na obrazie
	for (int i = 0; i<6; ++i) {
		cv::matchTemplate(src, templ, ftmp[i], i);
		cv::normalize(ftmp[i], ftmp[i], 1, 0, cv::MINMAX);
	}

	// wywietlanie wynikw
	//
	cv::imshow("Template", templ);
	cv::imshow("Image", src);
	cv::imshow("SQDIFF", ftmp[0]);
	cv::imshow("SQDIFF_NORMED", ftmp[1]);
	cv::imshow("CCORR", ftmp[2]);
	cv::imshow("CCORR_NORMED", ftmp[3]);
	cv::imshow("CCOEFF", ftmp[4]);
	cv::imshow("CCOEFF_NORMED", ftmp[5]);

	// aby uytkownik mia czas obejrze wyniki
	//
	cv::waitKey(0);
}
