// Listing 10.2. Inny sposb poczenia i ograniczenia wartoci paszczyzn obrazu

#include <opencv2/opencv.hpp>
#include <iostream>

using namespace std;

void sum_rgb( const cv::Mat& src, cv::Mat& dst ) {

	// dzieli obraz na paszczyzny kolorw
	//
	vector<cv::Mat> planes;
	cv::split(src, planes);
	cv::Mat b = planes[0], g = planes[1], r = planes[2];

	// akumuluje poszczeglne paszczyzny, czy i ogranicza
	//
	cv::Mat s = cv::Mat::zeros(b.size(), CV_32F);
	cv::accumulate(b, s);
	cv::accumulate(g, s);
	cv::accumulate(r, s);

	// ucina wartoci powyej 100 i skaluje do dst
	//
	cv::threshold( s, s, 100, 100, cv::THRESH_TRUNC );
	s.convertTo(dst, b.type());
}

void help(char **argv) {
	cout << "\nListing 10.2. Inny sposb poczenia i ograniczenia wartoci paszczyzn obrazu.\n" << endl;
	cout << "\nWywoanie:\n" << argv[0] << " ../faces.jpg\n" << endl;
}

int main(int argc, char** argv) {
	help(argv);
	if(argc < 2) { cout << "okrel obraz wejciowy" << endl; return -1; }

	// aduje okrelony obraz
	//
	cv::Mat src = cv::imread( argv[1] ), dst;
	if( src.empty() ) { cout << "Nie udao si zaadowa obrazu " << argv[1] << endl; return -1; }
	sum_rgb( src, dst);

	// tworzy okno o nazwie takiej samej, jak nazwa pliku graficznego i
	// wywietla ten obraz w tym oknie
	//
	cv::imshow( argv[1], dst );

	// czeka bezczynnie, a uytkownik nacinie jakikolwiek klawisz
	//
	cv::waitKey(0);
	return 0;
}
