// Listing 2.7. Detektor krawdzi Canny'ego wysya wyniki do jednokanaowego obrazu
// 2
#include <opencv2/opencv.hpp>

void help(char** argv ) {
	std::cout << "\n"
	<< "\nListing 2.7. Detektor krawdzi Canny'ego wysya wyniki do jednokanaowego obrazu."
    << "\nWywoanie:\n"  
	<< argv[0] <<" <path/image>\n"
	<< "Na przykad:\n"
	<< argv[0] << " ../fruits.jpg\n"
	<< std::endl;
}
	

int main( int argc, char** argv ) {
	
	if (argc != 2) {
		help(argv);
		return 0;
	}

  cv::Mat img_rgb, img_gry, img_cny;

  cv::namedWindow( "Przykad szary", cv::WINDOW_AUTOSIZE );
  cv::namedWindow( "Przykad Canny'ego", cv::WINDOW_AUTOSIZE );

  img_rgb = cv::imread( argv[1] );

  cv::cvtColor( img_rgb, img_gry, cv::COLOR_BGR2GRAY);
  cv::imshow( "Przykad szary", img_gry );

  cv::Canny( img_gry, img_cny, 10, 100, 3, true );
  cv::imshow( "Przykad Canny'ego", img_cny );

  cv::waitKey(0);

}
