// Listing 2.4. Dodanie suwaka do podstawowego okna widoku umoliwiajcego
// dowolne przegldanie filmu

#include "opencv2/highgui/highgui.hpp"
#include "opencv2/imgproc/imgproc.hpp"
#include <iostream>
#include <fstream>

using namespace std;

int g_slider_position = 0;
int g_run = 1, g_dontset = 0; // uruchomienie programu w trybie jednego kroku
cv::VideoCapture g_cap;

void onTrackbarSlide( int pos, void *) {

  g_cap.set( CV_CAP_PROP_POS_FRAMES, pos );

  if( !g_dontset ) g_run = 1;

  g_dontset = 0;

}


void help(char** argv ) {
	std::cout << "\n"
	<< "2.4: Dodanie do okna suwaka umoliwiajcego w/przegldanie filmu. \n"
	<< argv[0] <<" <path/video>\n"
	<< "Na przykad:\n"
	<< argv[0] << " ../tree.avi\n"
	<< std::endl;
}
	

int main( int argc, char** argv ) {
	
	if (argc != 2) {
		help(argv);
		return 0;
	}

  cv::namedWindow( "Listing 2.4", cv::WINDOW_AUTOSIZE );

  g_cap.open( string(argv[1]) );

  int frames = (int) g_cap.get( CV_CAP_PROP_FRAME_COUNT  );
  int tmpw   = (int) g_cap.get( CV_CAP_PROP_FRAME_WIDTH  );
  int tmph   = (int) g_cap.get( CV_CAP_PROP_FRAME_HEIGHT );

  cout << "Film zawiera " << frames << " ramek o wymiarach ("
       << tmpw << ", " << tmph << ")." << endl;

  cv::createTrackbar(
    "Pozycja",
    "Listing 2.4",
    &g_slider_position,
    frames,
    onTrackbarSlide
  );
  cv::Mat frame;

  for(;;) {

    if( g_run != 0 ) {
      g_cap >> frame;
      if(frame.empty()) break;
      int current_pos = (int)g_cap.get( CV_CAP_PROP_POS_FRAMES );
      g_dontset = 1;

      cv::setTrackbarPos("Pozycja", "Listing 2.4", current_pos);
      cv::imshow( "Listing 2.4", frame );
      g_run-=1;
    }

    char c = (char) cv::waitKey(10);

    if( c == 's' ) { // pojedynczy krok
      g_run = 1;
      cout << "Pojedynczy krok = " << g_run << endl;
    }

    if( c == 'r' ) { // tryb cigy
      g_run = -1;
      cout << "Tryb cigy = " << g_run <<endl;
    }

    if( c == 27 ) break;
  }

  return(0);

}


