 // Misja w nadprzestrzeń C++14/17, program z paragrafu  3.8


#include <iostream>
using namespace std;
/////////////////////////////////////////////////////////////////////////////////////////
// szablony klas w dwóch wersjach
/////////////////////////////////////////////////////////////////////////////////////////
template <typename T, T stala>					// po staremu			// `1
struct Tszk_stary
{
	Tszk_stary()
	{
		cout << __PRETTY_FUNCTION__ << endl;
	}

	T roboczy;
};
/////////////////////////////////////////////////////////////////////////////////////////
template < auto stala >						// po nowemu			// `2
struct Tszk_nowy
{
	Tszk_nowy()
	{
		cout << __PRETTY_FUNCTION__ << endl;
	}

	using T = decltype(stala); 	// jeśli bardzo potrzebujesz tego typu 	// `3
	T 	roboczy;													// `4
};
//*******************************************************************
// szablony funkcji – w wersji starej i nowej
//*******************************************************************
template < typename T, T stala > 				// po staremu			// `5
void stara_funszab()
{
	cout << __PRETTY_FUNCTION__
		<< "\n  wartosc stala = " << stala << endl;
}
//*******************************************************************
template < auto stala >						// po nowemu			// `6
void nowa_funszab()
{
	cout << __PRETTY_FUNCTION__
		<< "\n  wartosc stala = " << stala << endl;
}
//*******************************************************************
int obiekt = 10;  		// globalny 									// `7
/////////////////////////////////////////////////////////////////////////////////////////
class Tnn														// `8
{
	// ...
};
/////////////////////////////////////////////////////////////////////////////////////////
Tnn  n;				// globalny 									// `9
/////////////////////////////////////////////////////////////////////////////////////////
// Szablon o zmiennej liczbie parametrów (będących stałymi)
/////////////////////////////////////////////////////////////////////////////////////////
template < auto ... pakiet_stalych >  								// `10
struct Tszk_zm
{
	Tszk_zm()
	{
		cout << __PRETTY_FUNCTION__ << endl;
		auto suma = (... + pakiet_stalych);							// `11
		cout << "Suma parametrow = " << suma << endl;
	}
};
//*******************************************************************
int main()
{
	cout << "============= Obiekty klas szablonowych powstalych z szablonu Tszk_stary \n";

	Tszk_stary<int, 22>  							a;				// `12
	Tszk_stary<long int, 99922L> 					b;				// `13
	Tszk_stary<decltype(50+1000uL), 50+1000uL>  	c; 				// `14
	Tszk_stary<int*, &obiekt> 						d;				// `15
	Tszk_stary<decltype(&n), &n> 					e; 				// `16

	cout << "========== Obiekty klas szablonowych powstalych z szablonu Tszk_nowy\n";

	Tszk_nowy<22> 					a2;							// `17
	Tszk_nowy<99922L> 				b2;
	Tszk_nowy<50+1000uL>  			c2;
	Tszk_nowy<&obiekt>  				d2;
	Tszk_nowy<&n> 					e2;

	cout << "========== Funkcje szablonowe powstale z szablonu stara_funszab \n";

	stara_funszab<int, 4>();											// `18
	stara_funszab<char, '%'>();
	stara_funszab<int *, &obiekt>();
	stara_funszab<decltype(&n), &n>();

	cout << "========== Funkcje szablonowe powstale z szablonu nowa_funszab \n";

	nowa_funszab<4>();											// `19
	nowa_funszab<'%'>();
	nowa_funszab<&obiekt>();
	nowa_funszab<&n>();

	// klasa szablonowa ze zmienną liczbą parametrów
	Tszk_zm<1,2,3,4> v;											// `20
}
