/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 5.4: Chronograf
https://www.exploringarduino.com/content2/ch5

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Jednominutowy chronograf z opcją start, stop i reset

#include <Stepper.h>

//Większość silników NEMA-17 wykonuje 200 kroków
const int STEPS_PER_REV = 200; //200 kroków

//Aby wykonać jeden obrót na minutę,
//musimy wiedzieć, ile milisekund potrzebnych jest na jeden krok:
//60 s * 1000 ms / 200 kroków = 300 ms/krok
const int MS_PER_STEP = 300; 

//Piny mostku H
const int COIL1_MC1  = 2;  //Przełącznik 1 sterujący fazą 1
const int COIL1_MC2  = 3;  //Przełącznik 2 sterujący fazą 1
const int COIL2_MC1  = 4;  //Przełącznik 1 sterujący fazą 2
const int COIL2_MC2  = 5;  //Przełącznik 2 sterujący fazą 2

//Piny przycisków
const int START = 8;  //Przycisk Start
const int STOP  = 9;  //Przycisk Stop

//Zmienne przechowujące dane dotyczące ostatniego i aktualnego czasu oraz wykonanych kroków
unsigned long last_time = 0;
unsigned long curr_time = 0;
int steps_taken = 0;

// Inicjalizacja biblioteki obsługującej silnik krokowy i jej przekazanie do pinów sterujących przełącznikami
Stepper chronograph(STEPS_PER_REV, COIL1_MC1, COIL1_MC2, COIL2_MC1, COIL2_MC2);

void setup()
{
  //Ustawienie dużej prędkości, by każde "tyknięcie" było szybkie
  chronograph.setSpeed(200); //200 RPM

  //Ustawienie rezystorów podciągających na pinach przycisków
  pinMode(START, INPUT_PULLUP);
  pinMode(STOP, INPUT_PULLUP);
}

void loop()
{
  //Niekończąca się pętla - czekaj tutaj, dopóki nie zostanie wciśnięty przycisk Start
  //Średnik na końcu pętli While zatrzymuje nas
  //tutaj, dopóki warunek nie przestanie być prawdziwy.
  while(digitalRead(START) == HIGH);

  last_time = millis(); //Pobranie czasu rozpoczęcia
  //Wykonuj się dopóki nie zostanie naciśnięty przycisk Stop lub minie 1 minuta.
  while(digitalRead(STOP) == HIGH && steps_taken < STEPS_PER_REV)
  {
    curr_time = millis();
    
    //Jeżeli upłynęła odpowiednia liczba milisekund, wykonaj jeden krok.
    if(curr_time - last_time >= MS_PER_STEP)
    {
      chronograph.step(1); //Wykonaj jeden krok.
      steps_taken++; //Zwiększanie o 1 wartości steps_taken, liczącej liczbę wykonanych kroków
      last_time=curr_time; //Przypisanie bieżącego czasu do ostatniego czasu
    }
  }

  //Jeżeli dotarliśmy do tego miejsca, został naciśnięty przycisk Stop lub minęła jedna minuta.
  //Jeżeli nie został wykonany pełen obrót, wróć do pozycji startowej.
  if (steps_taken < STEPS_PER_REV) chronograph.step(-steps_taken);
  //Zerowanie zmiennej liczącej kroki
  steps_taken = 0;
  
}
