/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 17.3: Kod absolutnie minimalnego serwera
https://www.exploringarduino.com/content2/ch17

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Serwer Arduino do sterowania diodą LED i brzęczykiem piezoelektrycznym
// Część kodu zaadaptowana z przykładowego kodu Arduino napisanego przez Toma Igoe

#include <SPI.h>
#include <WiFi101.h>

// Informacje o sieci Wi-Fi
const char WIFI_SSID[]     = "TUTAJ UMIEŚĆ NAZWĘ SIECI";      // SSID sieci Wi-Fi
const char WIFI_PASSWORD[] = "TUTAJ UMIEŚĆ HASŁO DO SIECI";  // Hasło do sieci Wi-Fi

// Informowanie o statusie połączenia za pomocą znajdującej się na płytce diody LED 
const int ONBOARD_LED = 13;

// Piny, którę będą sterowane za pomocą formularza HTML.
const int RED     = 5;
const int GREEN   = 10;
const int BLUE    = 11;
const int SPEAKER = A5;

// Serwer będzie nasłuchiwał na porcie 80 (standardowy port HTTP).
WiFiServer server(80);

// Zmienna potrzebna do sprawdzania czy jesteśmy połączeni z punktem dostępu sieci Wi-Fi
int wifi_status = WL_IDLE_STATUS; 

void setup()
{
  // Ustawienie odpowiednich pinów czipa Wi-Fi
  WiFi.setPins(8,7,4,2);

  // Ustawienie pinów
  pinMode(ONBOARD_LED, OUTPUT);
  digitalWrite(ONBOARD_LED, LOW);
  pinMode(RED, OUTPUT);
  digitalWrite(RED, HIGH);    // Dioda RGB LED ze wspólną anodą jest zgaszona gdy ma stan wysoki.
  pinMode(GREEN, OUTPUT);
  digitalWrite(GREEN, HIGH);  // Dioda RGB LED ze wspólną anodą jest zgaszona gdy ma stan wysoki.
  pinMode(BLUE, OUTPUT);
  digitalWrite(BLUE, HIGH);   // Dioda RGB LED ze wspólną anodą jest zgaszona gdy ma stan wysoki.

  // Uruchomienie interfejsu szeregowego
  Serial.begin(9600);

  // M0 ma sprzętowy interfejs USB, dlatego poniższa linijka nie powinna być oznaczona jako komentarz,
  // jeśli chcesz, aby program czekał, aż otworzysz monitor portu szeregowego. Oznacz ją jako komentarz,
  // jeśli chcesz, aby szkic działał bez otwierania konsoli szeregowej (lub gdy moduł jest zasilany baterią).

  while(!Serial);

  Serial.print("Łączenie z: ");
  Serial.println(WIFI_SSID);
  WiFi.setTimeout(5000);  // Poczekaj 5 s na połączenie.
  while (wifi_status != WL_CONNECTED)
  {
    wifi_status = WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  }
  Serial.println("Połączono!\n");
  digitalWrite(ONBOARD_LED, HIGH);  // Po połączeniu zapal znajdującą się na płytce diodę LED.

  // Uruchom serwer
  server.begin();
  Serial.println("Serwer uruchomiony!");

  // Wyświetl przypisany przez DHCP adres IP
  IPAddress ip = WiFi.localIP();
  Serial.print("Steruj tym Arduino na: http://");
  Serial.println(ip);
  Serial.println("");
}

void loop()
{
  // Uruchom serwer nasłuchujący przychodzących połączeń z klientami.
  WiFiClient client = server.available();

  // Czy klient (przeglądarka) połączył się?
  if(client)
  {
    // Gdy połączenie jest aktywne, sprawdzaj przychodzące linie.
    String command = "";
    while (client.connected())
    {
      // Za jednym razem będziemy czytać jedną linijkę przychodzących danych.
      String incoming_line = "";
      // Użyj pętli do-while, abyśmy nie zaczęli sprawdzać formatowania linii,
      // dopóki łańcuch znaków nie zawiera swojego pierwszego znaku.
      do
      {
        while(!client.available());  // Czekaj na następny bajt
        char c = client.read();  // Gdy go otrzymasz, przeczytaj go
        incoming_line += c;  // i dołącz do bieżącej linii
      } while (!incoming_line.endsWith("\r\n"));
      
      Serial.print(incoming_line);  // Wyświetl właśnie otrzymaną linię

      // Wykonaj akcję wskazaną przez żądanie "GET".
      // Wyszukiwanie danych wyglądajacych jak "GET /?L=10 HTTP/1.1" w otrzymanych linijkach
      if (incoming_line.startsWith("GET /?"))
      {
        // Polecenie będzie wyglądać jak "L=10".
        command = incoming_line.substring(6,incoming_line.indexOf(" HTTP/1.1"));
      }
  
      // Jeżeli ostatnia linia była pusta (jedynie miała znak powrotu karetki i znak nowej linii),
      // to znaczy, że odebraliśmy już całe żądanie.
      if (incoming_line == "\r\n")
      {
        // Odpowiedź na wszystkie otrzymane ze strony żądania
        // Kod odpowiedzi 200: Żądanie zostało otrzymane i zrozumiane.
        client.println("HTTP/1.1 200 OK");
        client.println("Content-type:text/html");
        client.println();

        // Przycisk zmiany koloru czerwonego
        client.print("<form action='' method='get'>");
        client.print("<input type='hidden' name='L' value='" + String(RED) + "' />");
        client.print("<input type='submit' value='Zmień czerwony' />");
        client.print("</form>");
   
        // Przycisk zmiany koloru zielonego
        client.print("<form action='' method='get'>");
        client.print("<input type='hidden' name='L' value='" + String(GREEN) + "' />");
        client.print("<input type='submit' value='Zmień zielony' />");
        client.print("</form>");
   
        // Przycisk zmiany koloru niebieskiego
        client.print("<form action='' method='get'>");
        client.print("<input type='hidden' name='L' value='" + String(BLUE) + "' />");
        client.print("<input type='submit' value='Zmień niebieski' />");
        client.print("</form>");
   
        // Suwak zmieniający częstotliwość głośnika
        client.print("<form action='' method='get'>");
        client.print(
          "<input type='range' name='S' min='0' max='1000' step='100' value='0'/>");
        client.print("<input type='submit' value='Ustaw częstotliwość' />");
        client.print("</form>");

        // Tutaj możesz dodać więcej elementów formularza, by sterować innymi urządzeniami.

        // Zakończ pustą linią.
        client.println(); 
        
        // Możemy zakończyć połączenie.
        delay(50);
        client.stop();

        // Wykonaj otrzymane polecenie
        if (command.startsWith("L="))
        {
          int led_pin = command.substring(2).toInt();
          Serial.print("ZMIANA STANU PINU: ");
          Serial.println(led_pin);
          Serial.println("");
          digitalWrite(led_pin, !digitalRead(led_pin));
        }
        else if (command.startsWith("S="))
        {
          int speaker_freq = command.substring(2).toInt();
          Serial.print("USTAWIENIE CZĘSTOTLIWOŚĆI GŁOŚNIKA NA: ");
          Serial.println(speaker_freq);
          Serial.println("");
          if (speaker_freq == 0) noTone(SPEAKER);
          else tone(SPEAKER, speaker_freq);
        }
        // Tutaj możesz dodać kolejne wyrażenia 'else if' do obsługi innych poleceń.
      }
    }
  }
}
