/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 9.2: Efekt pływającego światła
https://www.exploringarduino.com/content2/ch9

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Animacja pływającego światła

const int SER   =8;    //Pin wejścia szeregowego rejestru przesuwnego
const int LATCH =9;    //Pin przerzutnika rejestru przesuwnego
const int CLK   =10;   //Pin zegara rejestru przesuwnego

//Sekwencja zapalonych diod LED
int seq[14] = {1,2,4,8,16,32,64,128,64,32,16,8,4,2};

void setup()
{
  //Ustawienie pinów jako wyjścia
  pinMode(SER, OUTPUT);
  pinMode(LATCH, OUTPUT);
  pinMode(CLK, OUTPUT);
}

void loop()
{
  for (int i = 0; i < 14; i++)
  {
    digitalWrite(LATCH, LOW);             //Przerzutnik w stanie niskim - rozpoczęcie przesyłania
    shiftOut(SER, CLK, MSBFIRST, seq[i]); //Najpierw przesuń najbardziej znaczący bit
    digitalWrite(LATCH, HIGH);            //Przerzutnik w stanie wysokim - zakończenie przesyłania
    delay(100);                           //Prędkość animacji
  }
}
