/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 9.3: Wykres słupkowy reagujący na odczyty odległości z czujnika
https://www.exploringarduino.com/content2/ch9

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/


//Wykres słupkowy reagujący na odczyty odległości z czujnika

const int SER   =8;    //Pin wejścia szeregowego rejestru przesuwnego
const int LATCH =9;    //Pin przerzutnika rejestru przesuwnego
const int CLK   =10;   //Pin zegara rejestru przesuwnego
const int DIST  =0;    //Czujnik odległości IR podłączony do analogowego pinu 0

//Możliwe konfiguracje diod LED
int vals[9] = {0,1,3,7,15,31,63,127,255};

//Maksymalna wartość zwrócona przez czujnik
int maxVal = 500;

//Minimalna wartość zwrócona przez czujnik
int minVal = 0;

void setup()
{
  //Ustawienie pinów jako wyjścia
  pinMode(SER, OUTPUT);
  pinMode(LATCH, OUTPUT);
  pinMode(CLK, OUTPUT);
}

void loop()
{
  int distance = analogRead(DIST);
  distance = map(distance, minVal, maxVal, 0, 8);
  distance = constrain(distance,0,8);

  digitalWrite(LATCH, LOW);                     //Przerzutnik w stanie niskim - rozpoczęcie przesyłania
  shiftOut(SER, CLK, MSBFIRST, vals[distance]); //Najpierw przesuń najbardziej znaczący bit
  digitalWrite(LATCH, HIGH);                    //Przerzutnik w stanie wysokim - zakończenie przesyłania
  delay(10);                                    //Prędkość animacji

}
