/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 8.1: Zapisywanie danych na temat temperatury i oświetlenia w pliku
https://www.exploringarduino.com/content2/ch8

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Zapisywanie danych na temat temperatury i oświetlenia w pliku 

#include <Keyboard.h>

const int TEMP   =0;      //Czujnik temperatury podłączony do analogowego pinu 0
const int LIGHT  =1;      //Czujnik światła podłączony do analogowego pinu 1
const int LED    =3;      //Czerwona dioda podłączona do pinu 3
const int BUTTON =2;      //Przycisk podłączony do pinu 2

boolean lastButton = LOW;    //Ostatni stan przycisku
boolean currentButton = LOW; //Aktualny stan przycisku
boolean running = false;     //Tryb zapisu danych domyślnie wyłączony
int counter = 1;             //Licznik wpisów

void setup()
{
  pinMode (LED, OUTPUT);   //Ustawienie diody jako wyjścia
  Keyboard.begin();        //Rozpoczęcie emulacji klawiatury
}

void loop()
{
  currentButton = debounce(lastButton);           //Odczytaj odbuty stan przycisku
 
  if (lastButton == LOW && currentButton == HIGH) //Jeżeli przycisk został naciśnięty...
    running = !running;                           //zmień tryb działania
  
  lastButton = currentButton;                     //Przypisz aktualny stan przycisku do poprzedniego stanu
 
  if (running)                            //Jeżeli tryb zapisu jest włączony...
  {
    digitalWrite(LED, HIGH);              //włącz diodę LED.
    if (millis() % 1000 == 0)             //Jeżeli czas, który upłynął od początku programu, jest wielokrotnością 1000...
    {
      int temperature = analogRead(TEMP); // odczytaj temperaturę,
      int brightness = analogRead(LIGHT); // oOdczytaj poziom oświetlenia,
      Keyboard.print(counter);            // wWyświetl numer wpisu,
      Keyboard.print(",");                // wWyświetl przecinek,
      Keyboard.print(temperature);        // wWyświetl temperaturę,
      Keyboard.print(",");                // wWyświetl przecinek,
      Keyboard.println(brightness);       // wWyświetl poziom jasności (i znak nowej linii),
      counter++;                          // zZwiększ licznik wpisów o jeden.

    }
  }
  else
  {
    digitalWrite(LED, LOW);  //Jeżeli tryb zapisu jest wyłączony, wyłącz diodę LED
  }
}

/*
* Funkcja odbicia
* Przekaż do niej poprzedni stan przycisku,
* i zwróć aktulany, odbity stan przycisku.
*/
boolean debounce(boolean last)
{
  boolean current = digitalRead(BUTTON);       // Odczytaj stan przycisku
  if (last != current)                         // Jeżeli jest inny...
  {
    delay(5);                                  // czekaj 5 ms,
    current = digitalRead(BUTTON);             // odczytaj stan ponownie.
  }
  return current;                              // Zwróć aktualną wartość
}
