/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 3.2: Monitorowanie temperatury
https://www.exploringarduino.com/content2/ch3

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// System monitorowania temperatury
const int BLED=9;          // Katoda koloru niebieskiego podłączona do pinu 9
const int GLED=10;         // Katoda koloru zielonego podłączona do pinu 10
const int RLED=11;         // Katoda koloru czerwonego podłączona do pinu 11
const int TEMP=0;          // Czujnik temperatury podłączony do pinu 0

const int LOWER_BOUND=139; // Dolna wartość progowa
const int UPPER_BOUND=147; // Górna wartość progowa

int val = 0;               // Zmienna przechowująca odczyty analogowe 


void setup()
{
  pinMode (BLED, OUTPUT); // Ustawienie pinu koloru niebieskiego jako wyjścia
  pinMode (GLED, OUTPUT); // Ustawienie pinu koloru zielonego jako wyjścia
  pinMode (RLED, OUTPUT); // Ustawienie pinu koloru czerwonego jako wyjścia
}

void loop()
{
  val = analogRead(TEMP);

  // Dioda świeci się na niebiesko
  if (val < LOWER_BOUND)
  {
    digitalWrite(RLED, HIGH);
    digitalWrite(GLED, HIGH);
    digitalWrite(BLED, LOW);
  }
  // Dioda świeci się na czerwono
  else if (val > UPPER_BOUND)
  {
    digitalWrite(RLED, LOW);
    digitalWrite(GLED, HIGH);
    digitalWrite(BLED, HIGH);
  }
  // Dioda świeci się na zielono
  else
  {
    digitalWrite(RLED, HIGH);
    digitalWrite(GLED, LOW);
    digitalWrite(BLED, HIGH);
  }
}
