/*
  Blink
  Powtarzanie zapalania diody LED na 1 sekundę i gaszenia jej na 1 sekundę.

  Większość Arduino posiada wbudowaną na płytce diodę LED. W przypadku UNO, MEGA i ZERO
  jest ona podłączona do pinu 13, a w przypadku MKR1000 do pinu 6. LED_BUILTIN jest przypisana
  do poprawnego pinu niezależnie od użytej płytki.
  Jeżeli chciałbyś się dowiedzieć, do którego pinu podłączona jest dioda LED na Twojej płytce,
  sprawdź specyfikację techniczną na stronie: https://www.arduino.cc/en/Main/Products

  Ten przykładowy kod jest domeną publiczną.
  
  zmieniony 8 Maja 2014
  przez Scotta Fitzgeralda
  
  zmieniony 2 Września 2016
  przez Arturo Guadalupiego
  
  zmieniony 8 Września 2016
  przez Colby Newmana
*/


// funkcja setup jest wywoływana tylko raz, po podłączneiu płytki do prądu i po resecie
void setup() {
  // inicjalizacja cyfrowego pinu LED_BUILTIN ustawionego jako wyjście
  pinMode(LED_BUILTIN, OUTPUT);
}

// funkcja loop wykonywana jest bez końca
void loop() {
  digitalWrite(LED_BUILTIN, HIGH);   // zapal diodę LED (HIGH oznacza poziom napięcia)
  delay(1000);                       // czekaj 1 sekundę
  digitalWrite(LED_BUILTIN, LOW);    // zgaś diodę LED przez ustawienie napięcia na LOW
  delay(1000);                       // czekaj 1 sekundę
}
