/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 14.2: Zapis i odczyt karty SD
https://www.exploringarduino.com/content2/ch14

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Zapisywanie i odczytywanie danych z karty SD

#include <SD.h> //Dołączenie biblioteki obsługującą karty SD

//Piny ustawione domyślnie przez bibliotekę SD
//MOSI = pin 11
//MISO = pin 12
//SCLK = pin 13

//Zawsze musimy ustawić pin CS
const int CS_PIN  = 10;

//Ustawienie prędkości domyślnej na 5 s
int refresh_rate = 5000;

void setup()
{
  Serial.begin(9600);
  Serial.println("Łączenie z kartą");
  
  //Pin CS musi być ustawiony jako wyjście
  pinMode(CS_PIN, OUTPUT);
 
  if (!SD.begin(CS_PIN))
  {
    Serial.println("Nieudane połączenie z kartą SD");
    while(1);
  }
  Serial.println("Karta SD gotowa od użycia");
 
  //Odczyt pliku konfiguracyjnego (speed.txt)
  File commandFile = SD.open("speed.txt");
  if (commandFile)
  {
     Serial.println("Odczyt pliku konfiguracyjnego");
  
     while(commandFile.available())
     {
       refresh_rate = commandFile.parseInt();
     }
     Serial.print("Prędkość odświeżania = ");
     Serial.print(refresh_rate);
     Serial.println("ms");
     commandFile.close(); //Po skończonej pracy zamknij plik
  }  
  else
  {
    Serial.println("Nieudany odczyt pliku konfiguracyjnego");
    Serial.print("Zostanie zastosowana domyślna prędkość odświeżania: ");
    Serial.print(refresh_rate);
    Serial.println("ms!");
  } 
}

void loop()
{
  long timeStamp = millis();
  String dataString = "Witaj!";
 
  //Otwarcie pliku i zapisanie w nim danych 
  File dataFile = SD.open("log.csv", FILE_WRITE);
  if (dataFile)
  {
    dataFile.print(timeStamp);
    dataFile.print(",");
    dataFile.println(dataString);
    dataFile.close(); //Dane nie zostaną zapisane dopóki nie wywołamy polecenia close()!
  
    //Wyświetlanie zapisanych danych w monitorze portu szeregowego na potrzeby debugowania
    Serial.print(timeStamp);
    Serial.print(",");
    Serial.println(dataString);
  }
  else
  {
    Serial.println("Błąd podczas próby otwarcia pliku rejestru");
  }
  delay(refresh_rate);
} 
