/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 12.3: Osobisty termostat
https://www.exploringarduino.com/content2/ch12

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Niech nigdy nie będzie Ci za gorąco! To jest termostat.
// Temperatury są wyświetlane w formacie dwucyfrowym.


//Dołączenie biblioteki I2C i ustawienie adresu
#include <Wire.h>
#define TEMP_ADDR 72

//Dołączenie biblioteki LCD i inicjalizacja obiektu lcd
#include <LiquidCrystal.h>
LiquidCrystal lcd(2, 3, 4, 5, 6, 7);

//Znak specjalny stopnia
byte degree[8] = {
  B00110,
  B01001,
  B01001,
  B00110,
  B00000,
  B00000,
  B00000,
  B00000,
};

//Znak specjalny wskaźnika włączonego wentylatora
byte fan_on[8] = {
  B00100,
  B10101,
  B01110,
  B11111,
  B01110,
  B10101,
  B00100,
  B00000,
};

//Znak specjalny wskaźnika wyłączonego wentylatora
byte fan_off[8] = {
  B00100,
  B00100,
  B00100,
  B11111,
  B00100,
  B00100,
  B00100,
  B00000,
};

//Podłączenia pinów
const int SPEAKER     =8;
const int DOWN_BUTTON =9;
const int UP_BUTTON   =10;
const int FAN         =11;

//Zmienne potrzebne do wyelminowania problemu drgających styków
boolean lastDownTempButton = LOW;
boolean currentDownTempButton = LOW;
boolean lastUpTempButton = LOW;
boolean currentUpTempButton = LOW;

int set_temp = 23;    //Domyślna temperatura docelowa
boolean one_time = false; //Ustawienie pojedynczego dźwięku głośnika

void setup()
{
  pinMode(FAN, OUTPUT);
 
  //Utworzenie obiektu Wire dla czujnika temperatury
  Wire.begin();
 
  //Ustawienie liczby kolumn i wierszy wyświetlacza LCD
  lcd.begin(16, 2);
 
  //Przypisanie ID stworzonym znakom specjalnym 
  lcd.createChar(0, degree);
  lcd.createChar(1, fan_off);
  lcd.createChar(2, fan_on);
 
  //Wyświetlenie niezmiennej informacji na ekranie LCD
  lcd.setCursor(0,0);
  lcd.print("Aktualna:");
  lcd.setCursor(11,0);
  lcd.write((byte)0);
  lcd.setCursor(12,0);
  lcd.print("C");
  lcd.setCursor(0,1);
  lcd.print("Docelowa:");
  lcd.setCursor(11,1);
  lcd.write((byte)0);
  lcd.setCursor(12,1);
  lcd.print("C");
  lcd.setCursor(15,1);
  lcd.write(1); 
}

//Funkcja eliminująca problem drgajacych styków, która może być używana przez oba przyciski
boolean debounce(boolean last, int pin)
{
  boolean current = digitalRead(pin);
  if (last != current)
  {
    delay(5);
    current = digitalRead(pin);
  }
  return current;
}

void loop()
{
  //Odczyt temperatury
  Wire.beginTransmission(TEMP_ADDR); //Nawiązanie połączenia
  Wire.write(0);                     //Zapytanie o rejestr 0
  Wire.endTransmission();            //Zakończenie transmisji
  
  //Żądanie 1 bajta
  int returned_bytes = Wire.requestFrom(TEMP_ADDR, 1);    
  
  //Jeżeli nie zostały zwrócone żadne dane, to znaczy, że coś jest nie działa.
  if (returned_bytes == 0)
  {
    lcd.clear();            //Czyszczenie wyświetlacza
    lcd.print("I2C Error"); //Pokazanie błędu
    while(1);               //Zatrzymanie programu
  }
  
  int c = Wire.read();               //Odczyt temperatury w Celsjuszach
  lcd.setCursor(8,0);                //Przesunięcie kursora
  lcd.print(c);                      //Wyświetlenie nowej wartości
  
  //Eliminacja problemu drgających styków dla obu przycisków
  currentDownTempButton = debounce(lastDownTempButton, DOWN_BUTTON);
  currentUpTempButton  = debounce(lastUpTempButton, UP_BUTTON);
 
  //Obniżenie wartości docelowej
  if (lastDownTempButton== LOW && currentDownTempButton == HIGH)
  {
    set_temp--;
  }
  //Zwiększenie wartości docelowej
  else if (lastUpTempButton== LOW && currentUpTempButton  == HIGH)
  {
    set_temp++;
  }
  //Wyświetlenie wartości docelowej
  lcd.setCursor(8,1);
  lcd.print(set_temp);
  lastDownTempButton = currentDownTempButton;
  lastUpTempButton = currentUpTempButton;
 
  //Jest za gorąco!
  if (c >= set_temp)
  {
    //Sprawdzenie czy głośnik wydał już dźwięk
    if (!one_time)
    { 
      tone(SPEAKER, 400);
      delay(500);
      one_time = true;
    }
    //Wyłączenie głośnika gdy został wydany jeden dźwięk 
    else
    {
      noTone(SPEAKER);
    }
    //Włączenie wentylatora i aktualizacja wyświetlacza
    digitalWrite(FAN, HIGH);
    lcd.setCursor(15,1);
    lcd.write(2);
  }
  //Nie jest za gorąco!
  else
  {
    //Upewnienie się, że głośnik jest wyłączony i reset zmiennej przechowującej informacje o pojedynczym dźwięku
    //Aktualizacja stanu wentylatora i wyświetlacza LCD
    noTone(SPEAKER);
    one_time = false;
    digitalWrite(FAN, LOW);
    lcd.setCursor(15,1);
    lcd.write(1);
  }
}
