/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 10.1: Wyświetlanie odczytów czujnika temperatury w monitorze portu szeregowego
https://www.exploringarduino.com/content2/ch10

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/


//Odczyt temperatury z czujnika temperatury I2C
//oraz wyświetlanie odczytów w monitorze portu szeregowego

//Import biblioteki Wire, obsługującej I2C
#include <Wire.h>
int temp_address = 72; //binarna liczba 1001000 zapisana w systemie dziesiętnym 

void setup()
{
  //Włączenie terminala portu szeregowego z przepustowością równą 9600
  Serial.begin(9600);
 
  //Utwórz obiekt klasy Wire
  Wire.begin();
}

void loop()
{
  //Wysłanie żądania
  //Rozpoczęcie komunikacji z urządzeniem o określonym adresie
  Wire.beginTransmission(temp_address); 
  //Wysłanie bitu z żądaniem rejestru zero, rejestr danych
  Wire.write(0); 
  //Zakończenie transmisji
  Wire.endTransmission(); 
 
  //Odczyt temperatury z urządzenia
  //Żądanie 1 bajta z określonego adresu
  int returned_bytes = Wire.requestFrom(temp_address, 1);
  
  //Jeśli nie zostały zwrócone żadne dane, to znaczy, że wystąpił błąd.
  if (returned_bytes == 0)
  {
    Serial.println("I2C Error"); //Wyświetlenie błędu
    while(1);                    //Zatrzymanie programu
  }
  
  //Pobranie temperatury i zapisanie jej do zmiennej
  int c = Wire.read(); 
 
  //Zamiana stopni Celsjusza na stopnie Fahrenheita
  int f = round(c*9.0/5.0 +32.0);
 
  //Wyświetlenie temperatury w stopniach Celsjusza i Fahrenheita w monitorze portu szeregowego
  Serial.print(c);
  Serial.print("C ");
  Serial.print(f);
  Serial.println("F");
 
  delay(500);
}
