/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 10.3: Szkic Processing wyświetlający wartości temperatury
https://www.exploringarduino.com/content2/ch10

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Wyświetlanie temperatury zarejestrowanej przez czujnik I2C

import processing.serial.*;
Serial port;
String temp_c = "";
String temp_f = "";
String data = "";
int index = 0;
PFont font;

void setup()
{
  size(400,400);
  //Zamień "COM9" na nazwę swojego portu szeregowego
  
  port = new Serial(this, "COM9", 9600);
  port.bufferUntil('.'); 
  //Zamień nazwę czcionki na nazwę tej, którą wybrałeś
  font = loadFont("AgencyFB-Bold-200.vlw");
  textFont(font, 200);
}

void draw()
{
  background(0,0,0);
  fill(46, 209, 2);
  text(temp_c, 70, 175);
  fill(0, 102, 153);
  text(temp_f, 70, 370);
}
 
void serialEvent (Serial port)
{
  data = port.readStringUntil('.');
  data = data.substring(0, data.length() - 1);
 
  // Szukanie przecinka pomiędzy temperaturą w stopniach Celsjusza
  // a  temperaturą w stopniach Fahrenheita

  index = data.indexOf(",");
   // Pobranie temperatury w stopniach Celsjusza
  temp_c = data.substring(0, index);
   // Pobranie temperatury w stopniach Fahrenheita
  temp_f = data.substring(index+1, data.length());
}
