/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 9.1: Zapalanie co drugiej diody LED za pomocą rejestru przesuwnego
https://www.exploringarduino.com/content2/ch9

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Zapalanie co drugiej diody LED za pomocą rejestru przesuwnego

const int SER   =8;    //Pin wejścia szeregowego rejestru przesuwnego
const int LATCH =9;    //Pin przerzutnika rejestru przesuwnego
const int CLK   =10;   //Pin zegara rejestru przesuwnego

void setup()
{
  //Ustawienie pinów jako wyjścia
  pinMode(SER, OUTPUT);
  pinMode(LATCH, OUTPUT);
  pinMode(CLK, OUTPUT);
  
  digitalWrite(LATCH, LOW);                //Ustawienie stanu niskiego przerzutnika
  shiftOut(SER, CLK, MSBFIRST, B10101010); //Najpierw przesuń najbardziej znaczący bit 
  digitalWrite(LATCH, HIGH);               //Przełączenie przerzutnika w stan wysoki - zapalenie diod LED wg wzoru
}

void loop()
{
  //W głównej pętli nic się nie wykonuje
}
