/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 7.1: Program wyświetlający odczyty z potencjometru w terminalu
https://www.exploringarduino.com/content2/ch7

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Prosty test terminala portu szeregowego

const int POT=0;  //Potencjometr podłączony do analogowego pinu 0

void setup()
{
  Serial.begin(9600); //Włącz terminal portu szeregowego z przepustowością równą 9600
}

void loop()
{
  int val = analogRead(POT);           //Odczytaj wartość z potencjometru
  int per = map(val, 0, 1023, 0, 100); //Oblicz procent
  Serial.print("Odczyt analogowy: ");   
  Serial.print(val);                   //Wyświetl odczytaną wartość analogową
  Serial.print("  Wartość procentowa: ");     
  Serial.print(per);                   //Wyświetl analogową wartość w procentach
  Serial.println("%");                 //Wyświetl znak % w nowej linii
  delay(1000);                         //Odczekaj 1 s, a następnie powtórz
}
