// Wysyłanie kilku zmiennych naraz
// Format wysyłania danych: <0-100>,<0-100>,<0,100)>\n
// Każda z trzech liczb reprezentuje wartość procentową jasności kanałów R, G, B

// Definicja pinów diody LED
const int RED   = 11;
const int GREEN = 10;
const int BLUE  = 9;

void setup()
{
  Serial.begin(9600);    // Włącz terminal portu szeregowego z przepustowością równą 9600
  Serial.setTimeout(10); // Terminal portu szeregowego czeka na liczbę całkowitą
 
  // Ustawienie pinów jako wyjścia
  pinMode(RED, OUTPUT);
  pinMode(GREEN, OUTPUT);
  pinMode(BLUE, OUTPUT);

  // Wyłączenie diody.
  // Jest to dioda ze wspólną anodą, dlatego ustawienie pinu katody na HIGH wyłącza diodę
  digitalWrite(RED, HIGH);
  digitalWrite(GREEN, HIGH);
  digitalWrite(BLUE, HIGH);
}

void loop()
{
  // Odczytywanie danych, gdy są dostępne w buforze
  if (Serial.available() > 0)
  {
    // Założenie, że przez port szeregowy zostaną odebrane trzy liczby całkowite
    // Funkcja parseInt będzie zablokowana, dopóki nie otrzyma poprawnej liczby całkowitej
    // Funkcja parseInt wie, że kompletna liczba całkowita została już odebrana, gdy zostaje odebrany znak nienumeryczny
    // Funkcja parseInt usuwa niepoprawne znaki tylko przed znalezioną liczbą całkowitą, a nie po niej
    int val1 = Serial.parseInt();
    int val2 = Serial.parseInt();
    int val3 = Serial.parseInt();

    // Usunięcie wszystkiego, co pozostało w buforze po przeczytaniu liczb całkowitych
    while (Serial.available())
    {
      Serial.read();
    }

    // Zaokrąglenie, w dół albo w górę, odebranych wartości, tak by mieściły się w zakresie od 0 do 100%
    int val1c = constrain(val1,0,100);
    int val2c = constrain(val2,0,100);
    int val3c = constrain(val3,0,100);

    // Przypisanie wartości procentowych do wartości analogowych
    int rval = map(val1c,0,100,255,0);  // pierwsza poprawna liczba całkowita
    int gval = map(val2c,0,100,255,0);  // druga poprawna liczba całkowita
    int bval = map(val3c,0,100,255,0);  // trzecia poprawna liczba całkowita

    // Ustawienie jasności diody LED
    analogWrite(RED, rval);
    analogWrite(GREEN, gval);
    analogWrite(BLUE, bval);
    
    // Wyświetl wartości, które zostały wykorzystane do ustawienia diody LED
    Serial.println("Czerwony:   " + String(val1c) + "%");
    Serial.println("Zielony: " + String(val2c) + "%");
    Serial.println("Niebieski:  " + String(val3c) + "%\n");
  }
}
