/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 11.2: Instrument bazujący na akcelerometrze
https://www.exploringarduino.com/content2/ch11

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Wykorzystanie wszystkich osi akcelerometru do sterowania światłem i dźwiękami

// Dołączenie bibliotek
// Ta biblioteka już sama w sobie zawiera biblioteki SPI i Universal Sensor Libraries
#include <Adafruit_LIS3DH.h>

// Określenie pinów (piny SPI są używane domyślnie)
const int RED_PIN = 6;
const int GREEN_PIN = 5;
const int BLUE_PIN = 3;
const int SPEAKER = 9;
const int CS_PIN = 10;

// Pianino pentatoniczne C D E G A
#define NOTE_C  262 //Hz
#define NOTE_D  294 //Hz
#define NOTE_E  330 //Hz
#define NOTE_G  392 //Hz
#define NOTE_A  440 //Hz
#define NOTE_C2 523 //Hz

// Utworzenie obiektu akcelerometru za pomocą sprzętowego interfejsu SPI
Adafruit_LIS3DH accel = Adafruit_LIS3DH(CS_PIN);

void setup()
{
  Serial.begin(9600); // Włączenie portu szeregowego w celu wyświetlania odczytów
  
  // Połączenie z akcelerometrem
  if (!accel.begin())
  {
    Serial.println("Nie odnaleziono akcelerometru.");
    while (1); // Nieskończona pętla
  }

  // Ustawienie czułości akcelerometru na +/- 2 g
  accel.setRange(LIS3DH_RANGE_2_G);


  // Ustawienie pinów katody diody LED jako wyjścia i ich wyłączenie
  // HIGH wyłącza diodę, gdyż jest to dioda ze wspólną anodą
  pinMode(RED_PIN, OUTPUT);
  digitalWrite(RED_PIN, HIGH);
  pinMode(GREEN_PIN, OUTPUT);
  digitalWrite(GREEN_PIN, HIGH);
  pinMode(BLUE_PIN, OUTPUT);
  digitalWrite(BLUE_PIN, HIGH);
}

void loop()
{
  // Odczyt przyspieszenia osi X, Y, Z
  accel.read();

// Normalizacja osi, która jest skierowana ku ziemi
  // Odjęcie wartości odpowiadającej 1 g od wartości odczytanej z akcelerometru

  long norm_z = accel.z-16384;

  // Wyświetlenie przyspieszeń wszystkich osi w celu dobrania wartości progowych
  Serial.print(accel.x);
  Serial.print(" ");
  Serial.print(accel.y);
  Serial.print(" ");
  Serial.println(norm_z);

  // Wywołanie różnych, w zależności od kierunku przyspieszenia, dźwięków o długości 100 ms  
  if (accel.x < -5000) tone(SPEAKER, NOTE_C, 100);
  if (accel.x > 5000) tone(SPEAKER, NOTE_D, 100);
  if (accel.y < -5000) tone(SPEAKER, NOTE_E, 100);
  if (accel.y > 5000) tone(SPEAKER, NOTE_G, 100);
  if (norm_z < -5000) tone(SPEAKER, NOTE_A, 100);
  if (norm_z > 5000) tone(SPEAKER, NOTE_C2, 100);

  // Zapalenie diody LED z jasnością proporcjonalną do kierunku przyspieszenia
  analogWrite(RED_PIN, constrain(map(abs(accel.x),5000,20000,255,0),0,255));
  analogWrite(GREEN_PIN, constrain(map(abs(accel.y),5000,20000,255,0),0,255));
  analogWrite(BLUE_PIN, constrain(map(abs(norm_z),5000,20000,255,0),0,255));
}
