/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 10.2: Czujnik temperatury I2C z rejstrem przesuwnym, diodami LED i komunikacją szeregową
https://www.exploringarduino.com/content2/ch10

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/


//Odczytuje temperaturę z czujnika I2C,
//a następnie pokazuje ją na diodowym wykresie słupkowym i w Processing.

//Import biblioteki Wire, obsługującej  I2C
#include <Wire.h>

const int SER   =8;    //Pin wejścia szeregowego rejestru przesuwnego
const int LATCH =9;    //Pin przerzutnika rejestru przesuwnego
const int CLK   =10;   //Pin zegara rejestru przesuwnego

int temp_address = 72;

//Możliwe konfiguracje diod LED
int vals[8] = {1,3,7,15,31,63,127,255};

void setup()
{
  //Rozpoczęcie komunikacji szeregowej z prędkością 9600 b/s
  Serial.begin(9600);
 
  //Utworzenie obiektu klasy Wire
  Wire.begin();
 
  //Ustawienie styków rejestru przesuwnego jako wyjścia
  pinMode(SER, OUTPUT);
  pinMode(LATCH, OUTPUT);
  pinMode(CLK, OUTPUT);
}

void loop()
{
  //Wysłanie żądania
  //Rozpoczęcie komunikacji z urządzeniem o określonym adresie
  Wire.beginTransmission(temp_address); 
  //Wysłanie bitu z żądaniem rejestru zero, rejestr danych
  Wire.write(0); 
  //Zakończenie transmisji
  Wire.endTransmission(); 
 
  //Odczyt temperatury z urządzenia
  //Żądanie 1 bajta z określonego adresu
  int returned_bytes = Wire.requestFrom(temp_address, 1); 

  //Jeśli nie zostały zwrócone żadne dane, to znaczy, że wystąpił błąd.
  if (returned_bytes == 0)
  {
    Serial.print("Err,Err."); //Wyświetlenie błędu
    while(1);
  }
    
  //Pobranie temperatury i zapisanie jej do zmiennej
  int c = Wire.read(); 
 
  //Przypisanie temperatury do konfiguracji oświetlenia diod LED
  int graph = map(c, 24, 31, 0, 7);
  graph = constrain(graph,0,7);

  digitalWrite(LATCH, LOW);         //Przerzutnik w stanie niskim - rozpoczęcie przesyłania
  shiftOut(SER, CLK, MSBFIRST, vals[graph]); //Najpierw przesuń najbardziej znaczący bit
  digitalWrite(LATCH, HIGH);        //Przerzutnik w stanie wysokim - zakończenie przesyłania
 
  //Zamiana stopni Celsjusza na stopnie Fahrenheita
  int f = round(c*9.0/5.0 +32.0);
 
  Serial.print(c);
  Serial.print("C,");
  Serial.print(f);
  Serial.print("F.");
 
  delay(500);
}
