/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 2.5: Przełączanie drgającego przycisku
https://www.exploringarduino.com/content2/ch2

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

const int LED=9;             // Dioda LED podłączona jest do pinu 9
const int BUTTON=2;          // Przycisk podłączony jest od pinu 2
boolean lastButton = LOW;    // Zmienna przechowująca poprzedni stan przycisku
boolean currentButton = LOW; // Zmienna przechowująca aktualny stan przycisku
boolean ledOn = false;       // Aktualny stan diody LED (on/off)

void setup()
{
  pinMode (LED, OUTPUT);     // Ustawienie pinu LED jako wyjście
  pinMode (BUTTON, INPUT);    // Ustawienie pinu BUTTON jako wejście (niewymagane)
}

/*
* Funkcja odbicia
* Przekaż do niej poprzedni stan przycisku,
* i zwróć aktulany, odbity stan przycisku.
*/
boolean debounce(boolean last)
{
  boolean current = digitalRead(BUTTON);       // Odczytaj stan przycisku
  if (last != current)                         // Jeżeli jest inny...
  {
    delay(5);                                  // Czekaj 5 ms
    current = digitalRead(BUTTON);             // Odczytaj stan ponownie
  }
  return current;                              // Zwróć aktualną wartość
}

void loop()
{
  currentButton = debounce(lastButton);              // Odczytaj stan przycisku
  if (lastButton == LOW && currentButton == HIGH)    // Jeżeli przycisk został naciśnięty...
  {
    ledOn = !ledOn;                                  // Zmień wartość diody LED na przeciwną
  }
  lastButton = currentButton;                        // Zresetuj wartość przycisku
  
  digitalWrite(LED, ledOn);                          // Zmień stan diody LED

}
