//    Oprogramowanie do automatyki domowej, doczone do ksiki
//    'Projekty Arduino + Android dla Maego Geniusza'
//    Copyright (C) 2011. Simon Monk
//
//    Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
//    zgodnie z warunkami Powszechnej Licencji Publicznej GNU w wersji 3 lub nowszej
//    opublikowanej przez Free Software Foundation 
//
//    Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
//    uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
//    gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
//    ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
//    Licencja Publiczna GNU. 
//
//    Razem z tym oprogramowaniem powiniene otrzyma kopi Powszechnej
//    Licencji Publicznej GNU. Jeeli nie otrzymae, odwied stron http://www.gnu.org/licenses

package com.simonmonk.home;

import java.util.Date;
import android.content.SharedPreferences;


class TimerMonitor extends Thread
{
	private HomeActivity mActivity;
	
	public TimerMonitor(HomeActivity activity)
	{
		super();
		mActivity = activity;
	}
	
	public void run()
	{
		while (true)
		{
			for (int i = 1; i <= 5; i++)
			{
				handleTimerNumber(i);
				try 
				{
					Thread.sleep(5000);
				} 
				catch (InterruptedException e) 
				{
					e.printStackTrace();
				}
			}
			try 
			{
				Thread.sleep(10000);
			} 
			catch (InterruptedException e) 
			{
				e.printStackTrace();
			}
		}
	}
	
	
	private void handleTimerNumber(int i) 
	{
		String itemStr = getSetting("TIMER_OP" + i);
		if ("null".equals(itemStr))
		{
			return; // timer jest nie uywany
		}
		String startTimeStr = getSetting("TIMER_ON"+ i);
		String endTimeStr = getSetting("TIMER_OFF" + i);
		int start = Integer.parseInt(startTimeStr);
		int end = Integer.parseInt(endTimeStr);
		int op = Integer.parseInt(itemStr);
		// porwnanie z biecym czasem i jeeli timer nie jest wczony, wcz go
		// mona porwna tylko cztery cyfry czasu
		Date d = new Date();
		int t = d.getHours() * 100 + d.getMinutes();

		boolean shouldBeOn = false;
		// jeeli czas wyczenia jest przed czasem wczenia, oznacza on nastpny dzie
		if (end < start)
		{
			end = end + 2400;
		}
		shouldBeOn = (t >= start && t < end);
		DigitalOutputs outputs = mActivity.outputs;
		if (shouldBeOn && ! outputs.isOn(op))
		{
			outputs.turnOn(op);
		}
		if (! shouldBeOn && outputs.isOn(op))
		{
			outputs.turnOff(op);
		}
	}

	String getSetting(String name)
	{
		SharedPreferences settings = mActivity.getSharedPreferences(PrefsActivity.PREFS_NAME, 0);
        return settings.getString(name, "null");
	}
	  
}
