/**
 * Kod rdowy do ksiki Projekty Arduino + Android dla Maych Geniuszy
 * Copyright 2011 Simon Monk
 *
 * Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
 * zgodnie z warunkami Powszechnej Licencja Publicznej GNU w wersji 2,
 * opublikowanej przez Free Software Foundation (patrz sekcja KOPIOWANIE).
 
 * Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
 * uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
 * gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
 * ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
 * Licencja Publiczna GNU. 
 */

package org.simonmonk.tv;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnLongClickListener;
import android.widget.Button;
import android.widget.Toast;


public class InputController extends AccessoryController implements OnClickListener, OnLongClickListener {

	private int index = 0;
	private final int n = 9;
    private SharedPreferences settings = mHostActivity.getSharedPreferences(SettingsActivity.PREFS_NAME, 0);


	InputController(DroidTVActivity hostActivity) {
		super(hostActivity);
		Log.d("SRM", "konstruktor");
		mHostActivity = hostActivity;

		for (int i = 0; i < n; i++) {
			int buttonID = getResources().getIdentifier("button" + i, "id", hostActivity.getPackageName());
			Button button = (Button) findViewById(buttonID);
			button.setOnClickListener(this);
			button.setOnLongClickListener(this);
			
			String label = settings.getString("label"+i, "-");
			
			button.setText(label);
			button.setTag(new Integer(i));
		}
	}

	
	protected void onAccesssoryAttached() {
	}
	
	@Override
	public void onClick(View v) {
		// wylij nacinit cyfr do Arduino
		index = (Integer)v.getTag();
	//	toast("i="+ index);
		mHostActivity.sendCommand((byte)1,(byte)0, index);
	}


	@Override
	public boolean onLongClick(View v) {
		// dugie przytrzymanie i otwarcie menu kontekstowego
//		index = (Integer)v.getTag();
//		openSettings(index);
		
		return false;
	}
	
	public void openSettings()
	{
		Bundle bundle = new Bundle();
		bundle.putLong("index", new Long(index));
		Intent newIntent = new Intent(mHostActivity, SettingsActivity.class);
		newIntent.putExtras(bundle);
		mHostActivity.startActivityForResult(newIntent, 0);
	}
	
	public void sendProgramCommand()
	{
		mHostActivity.sendCommand((byte)1,(byte)1, index);
	}

	public void handleValueMessage(char flag, int reading) {
		Log.d("SRM", "komunikat odebrany z Arduino " + reading);
		if (flag == 'R') {
			toast("Zaprogramowany przycisk " + reading);
		}
	}

	void toast(CharSequence text) {
		Context context = mHostActivity.getApplicationContext();
		int duration = Toast.LENGTH_SHORT;
		Toast toast = Toast.makeText(context, text, duration);
		toast.show();
	}
	
	
}
