//    Oprogramowanie do automatyki domowej, doczone do ksiki
//    'Projekty Arduino + Android dla Maego Geniusza'
//    Copyright (C) 2011. Simon Monk
//
//    Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
//    zgodnie z warunkami Powszechnej Licencji Publicznej GNU w wersji 3 lub nowszej
//    opublikowanej przez Free Software Foundation 
//
//    Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
//    uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
//    gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
//    ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
//    Licencja Publiczna GNU. 
//
//    Razem z tym oprogramowaniem powiniene otrzyma kopi Powszechnej
//    Licencji Publicznej GNU. Jeeli nie otrzymae, odwied stron http://www.gnu.org/licenses

package com.simonmonk.home;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import android.app.Activity;

public class Template 
{
	private Activity mActivity;
	private String mValue;
	
	public Template(String resourceName, Activity activity)
	{
		mActivity = activity;
		mValue = readTemplate(resourceName);
	}
	
	public void set(String key, String value)
	{
		mValue = mValue.replaceAll("::" + key + "::", value);
	}
	
	public String toString()
	{
		return mValue;
	}
	
	private String readTemplate(String resourceName)
	{
		InputStream inputStream = null;
		try 
		{
			inputStream = mActivity.getAssets().open("templates/"+ resourceName + ".html");
		} 
		catch (IOException e) 
		{
			// TODO automatycznie wygenerowany blok catch
			e.printStackTrace();
			return "Szablon nie istnieje: " + resourceName;
		}
		return readTextFile(inputStream);
	}
	
	
    private String readTextFile(InputStream inputStream) 
    {
    	ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    	byte buf[] = new byte[1024];
    	int len;
    	try 
    	{
    		while ((len = inputStream.read(buf)) != -1) 
    		{
    	       outputStream.write(buf, 0, len);
    	    }
    	    outputStream.close();
    	    inputStream.close();
    	} 
    	catch (IOException e) 
    	{
    	}
    	return outputStream.toString();
   }
	
}
