/**
 * Kod rdowy do ksiki Projekty Arduino + Android dla Maych Geniuszy
 * Copyright 2011 Simon Monk
 *
 * Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
 * zgodnie z warunkami Powszechnej Licencja Publicznej GNU w wersji 2,
 * opublikowanej przez Free Software Foundation (patrz sekcja KOPIOWANIE).
 
 * Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
 * uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
 * gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
 * ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
 * Licencja Publiczna GNU. 
 */

package org.simonmonk.tv;

import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;


public class SettingsActivity extends Activity implements OnClickListener {

	public static final String PREFS_NAME = "TVPrefsFile";
	
	protected DroidTVActivity mHostActivity;


	Button saveButton;
	EditText labelField;

	
	
	   public void onCreate(Bundle savedInstanceState) {
	        super.onCreate(savedInstanceState);

	        setContentView(R.layout.settings);
	        
	        SharedPreferences settings = getSharedPreferences(PREFS_NAME, 0);
	        
	        
	        Bundle bundle = this.getIntent().getExtras();
	        Long index = bundle.getLong("index");

	        labelField = (EditText)findViewById(R.id.labelfield);
	        String label = settings.getString("label" + index, "-");
	        labelField.setText(label);
	        	       
	        saveButton = (Button)findViewById(R.id.saveButton);
	        saveButton.setOnClickListener(this);
	    }
	   


	public void onClick(View v) {
	    Bundle bundle = this.getIntent().getExtras();
        int index = (int)bundle.getLong("index");
		if (v == saveButton) {
			SharedPreferences settings = getSharedPreferences(PREFS_NAME, 0);
		    SharedPreferences.Editor editor = settings.edit();
		    
	        editor.putString("label"+index, labelField.getText().toString());
		    editor.commit();
		}
	}
}
