/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licencja Apache, wersja 2.0
 * Uywanie pliku niezgodnie z warunkami licencji zabronione.
 * Licencja jest dostpna pod adresem:
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * O ile nie wymaga tego obowizujce prawo, lub na pimie nie postanowi si inaczej,
 * oprogramowanie objte t licencj jest rozpowszechniane w takim stanie, w jakim jest
 * be adnych gwarancji ani warunkw, ani jawnych, ani domylnych.
 * Szczegowe warunki okrelaj waciwe przepisy i ograniczenia zawarte w tej Licencji
 * 
 */

package org.simonmonk.tv;

import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;

public class BaseActivity extends DroidTVActivity {

	private InputController mInputController;

	public BaseActivity() {
		super();
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		if (mAccessory != null) {
			showControls();
		} else {
			hideControls();
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		menu.add("Test");
		menu.add("Edycja");
		menu.add("Programowanie");
		
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		if (item.getTitle() == "Test") {
			showControls();
		} 
		if (item.getTitle() == "Edycja" && mInputController != null) {
			mInputController.openSettings();
		} 
		if (item.getTitle() == "Programowanie" && mInputController != null) {
			mInputController.sendProgramCommand();
		} 
		return true;
	}

	protected void enableControls(boolean enable) {
		if (enable) {
			showControls();
		} else {
			hideControls();
		}
	}

	protected void hideControls() {
		setContentView(R.layout.no_device);
		mInputController = null;
	}

	protected void showControls() {
		setContentView(R.layout.main);

		mInputController = new InputController(this);
		mInputController.accessoryAttached();
	}

	protected void handleValueMessage(ValueMsg t) {
		if (mInputController != null) {
			mInputController.handleValueMessage(t.getFlag(), t.getReading());
		}
	}

}