/**
 * Kod rdowy do ksiki Projekty Arduino + Android dla Maych Geniuszy
 * Copyright 2011 Simon Monk
 *
 * Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
 * zgodnie z warunkami Powszechnej Licencja Publicznej GNU w wersji 2,
 * opublikowanej przez Free Software Foundation (patrz sekcja KOPIOWANIE).
 
 * Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
 * uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
 * gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
 * ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
 * Licencja Publiczna GNU. 
 */

package org.simonmonk.rangefinder;

import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.RadioButton;
import android.widget.TextView;

public class InputController extends AccessoryController implements OnCheckedChangeListener, OnClickListener {
	private TextView mDistance;
	private TextView mLogView;
	private CheckBox mLaserCheckBox;
	private RadioButton mCmRadioButton;
	private RadioButton mInRadioButton;
	private boolean m_isCm = false;

	InputController(DroidGeigerActivity hostActivity) {
		super(hostActivity);
		mHostActivity = hostActivity;
		mDistance = (TextView) findViewById(R.id.distValue);
		mDistance.setOnClickListener(this);
		mLogView = (TextView) findViewById(R.id.logField);
		mLaserCheckBox = (CheckBox) findViewById(R.id.laser);
		mCmRadioButton = (RadioButton) findViewById(R.id.radio_cm);
		mCmRadioButton.setOnCheckedChangeListener(this);
		mInRadioButton = (RadioButton) findViewById(R.id.radio_inches);
		mInRadioButton.setOnCheckedChangeListener(this);
		mLaserCheckBox.setOnCheckedChangeListener(this);
	}

	
	protected void onAccesssoryAttached() {
	}
	
	public void clearLog()
	{
		mLogView.setText("");
	}

	public void handleGeigerMessage(char flag, int reading) {
		Log.d("SRM", "setDist " + reading);
		if (! m_isCm){
			reading = reading * 4 / 10;
		}
			
		if (flag == 'R')
		{
			mDistance.setText("" + reading);
		}
	}

	void setLaserState(int laserState)
	{
		Log.d("SRM", "ustawienie lasera na:" + laserState);
		mHostActivity.sendCommand((byte)1,(byte)0,laserState);
	}


	@Override
	public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
		if (buttonView == mLaserCheckBox) {
			if (isChecked)
			{
				setLaserState(1);
			}
			else
			{
				setLaserState(0);
			}
		}
		else if (buttonView == mCmRadioButton) {
			m_isCm = isChecked;
		}
		else if (buttonView == mInRadioButton) {
			m_isCm = ! isChecked;
		}
	}


	@Override
	public void onClick(View v) {
		// zapis odczytu
		String log = mLogView.getText().toString();
		String units = " in";
		if (m_isCm) {
			units = " cm";
		}
		mLogView.setText("" + mDistance.getText() + units + "\n" + log);
	}

}
