from PIL import Image,ImageDraw

def readfile(filename):
  lines=[line for line in file(filename)]
  
  # Pierwszy wiersz zawiera tytuły kolumn
  colnames=lines[0].strip().split('\t')[1:]
  rownames=[]
  data=[]
  for line in lines[1:]:
    p=line.strip().split('\t')
    # Pierwsza kolumna w każdym wierszu zawiera jego nazwę
    rownames.append(p[0])
    # dane dla tego wiersza to jego reszta
    data.append([float(x) for x in p[1:]])
  return rownames,colnames,data


from math import sqrt

def pearson(v1,v2):
  # zwykłe sumy
  sum1=sum(v1)
  sum2=sum(v2)
  
  # sumy kwadratów
  sum1Sq=sum([pow(v,2) for v in v1])
  sum2Sq=sum([pow(v,2) for v in v2])	
  
  # suma iloczynów
  pSum=sum([v1[i]*v2[i] for i in range(len(v1))])
  
  # obliczenie r (miara Pearsona)
  num=pSum-(sum1*sum2/len(v1))
  den=sqrt((sum1Sq-pow(sum1,2)/len(v1))*(sum2Sq-pow(sum2,2)/len(v1)))
  if den==0: return 0

  return 1.0-num/den

class bicluster:
  def __init__(self,vec,left=None,right=None,distance=0.0,id=None):
    self.left=left
    self.right=right
    self.vec=vec
    self.id=id
    self.distance=distance

def hcluster(rows,distance=pearson):
  distances={}
  currentclustid=-1

  # Początkowo klastry są tylko wierszami
  clust=[bicluster(rows[i],id=i) for i in range(len(rows))]

  while len(clust)>1:
    lowestpair=(0,1)
    closest=distance(clust[0].vec,clust[1].vec)

    # wykonanie pętli dla każdej pary w celu znalezienia najmniejszej odległości
    for i in range(len(clust)):
      for j in range(i+1,len(clust)):
        # Odległości znajdują się w pamięci podręcznej operacji obliczania odległości.
        if (clust[i].id,clust[j].id) not in distances: 
          distances[(clust[i].id,clust[j].id)]=distance(clust[i].vec,clust[j].vec)

        d=distances[(clust[i].id,clust[j].id)]

        if d<closest:
          closest=d
          lowestpair=(i,j)

    # obliczenie średniej dwóch klastrów
    mergevec=[
    (clust[lowestpair[0]].vec[i]+clust[lowestpair[1]].vec[i])/2.0 
    for i in range(len(clust[0].vec))]

    # utworzenie nowego klastra
    newcluster=bicluster(mergevec,left=clust[lowestpair[0]],
                         right=clust[lowestpair[1]],
                         distance=closest,id=currentclustid)

    # Identyfikatory klastrów, których nie było w pierwotnym zbiorze, są ujemne
    currentclustid-=1
    del clust[lowestpair[1]]
    del clust[lowestpair[0]]
    clust.append(newcluster)

  return clust[0]

def printclust(clust,labels=None,n=0):
  # zastosowanie wcięcia w celu utworzenia układu hierarchii
  for i in range(n): print ' ',
  if clust.id<0:
    # Ujemny identyfikator reprezentuje gałąź.
    print '-'
  else:
    # Dodatni identyfikator reprezentuje punkt końcowy
    if labels==None: print clust.id
    else: print labels[clust.id]

  # Zostaną teraz wyświetlone prawa i lewa gałąź.
  if clust.left!=None: printclust(clust.left,labels=labels,n=n+1)
  if clust.right!=None: printclust(clust.right,labels=labels,n=n+1)

def getheight(clust):
  # Czy to jest punkt końcowy? Jeśli tak, wysokość wynosi po prostu 1.
  if clust.left==None and clust.right==None: return 1

  # W przeciwnym razie wysokość stanowi sumę wysokości
  # wszystkich gałęzi.
  return getheight(clust.left)+getheight(clust.right)

def getdepth(clust):
  # Odległość punktu końcowego wynosi 0,0
  if clust.left==None and clust.right==None: return 0

  # Odległość gałęzi jest większą spośród odległości dwóch jej boków
  # powiększoną o jej własną odległość.
  return max(getdepth(clust.left),getdepth(clust.right))+clust.distance


def drawdendrogram(clust,labels,jpeg='clusters.jpg'):
  # wysokość i szerokość
  h=getheight(clust)*20
  w=1200
  depth=getdepth(clust)

  # Szerokość jest ustalona, dlatego odległości zostaną odpowiednio zeskalowane
  scaling=float(w-150)/depth

  # tworzenie nowego obrazu z białym tłem
  img=Image.new('RGB',(w,h),(255,255,255))
  draw=ImageDraw.Draw(img)

  draw.line((0,h/2,10,h/2),fill=(255,0,0))    

  # rysowanie pierwszego węzła
  drawnode(draw,clust,10,(h/2),scaling,labels)
  img.save(jpeg,'JPEG')

def drawnode(draw,clust,x,y,scaling,labels):
  if clust.id<0:
    h1=getheight(clust.left)*20
    h2=getheight(clust.right)*20
    top=y-(h1+h2)/2
    bottom=y+(h1+h2)/2
    # długość linii
    ll=clust.distance*scaling
    # linia pionowa prowadząca od danego klastra do węzłów podrzędnych    
    draw.line((x,top+h1/2,x,bottom-h2/2),fill=(255,0,0))    
    
    # linia pozioma prowadząca do lewej pozycji
    draw.line((x,top+h1/2,x+ll,top+h1/2),fill=(255,0,0))    

    # linia pozioma prowadząca do prawej pozycji
    draw.line((x,bottom-h2/2,x+ll,bottom-h2/2),fill=(255,0,0))        

    # wywołanie funkcji w celu narysowania lewego i prawego węzła    
    drawnode(draw,clust.left,x+ll,top+h1/2,scaling,labels)
    drawnode(draw,clust.right,x+ll,bottom-h2/2,scaling,labels)
  else:   
    # Jeśli to jest punkt końcowy, zostanie narysowana etykieta pozycji.
    draw.text((x+5,y-7),labels[clust.id],(0,0,0))

def rotatematrix(data):
  newdata=[]
  for i in range(len(data[0])):
    newrow=[data[j][i] for j in range(len(data))]
    newdata.append(newrow)
  return newdata

import random

def kcluster(rows,distance=pearson,k=4):
  # określanie minimalnych i maksymalnych wartości dla każdego punktu
  ranges=[(min([row[i] for row in rows]),max([row[i] for row in rows])) 
  for i in range(len(rows[0]))]

  # tworzenie k losowo rozmieszczonych centroidów
  clusters=[[random.random()*(ranges[i][1]-ranges[i][0])+ranges[i][0] 
  for i in range(len(rows[0]))] for j in range(k)]
  
  lastmatches=None
  for t in range(100):
    print 'Iteracja %d' % t
    bestmatches=[[] for i in range(k)]
    
    # określanie, który centroid jest najbliższy dla każdego wiersza
    for j in range(len(rows)):
      row=rows[j]
      bestmatch=0
      for i in range(k):
        d=distance(clusters[i],row)
        if d<distance(clusters[bestmatch],row): bestmatch=i
      bestmatches[bestmatch].append(j)

    # Jeśli wyniki są takie same jak ostatnim razem, oznacza to zakończenie procesu.
    if bestmatches==lastmatches: break
    lastmatches=bestmatches
    
    # przemieszczenie centroidów do średniej ich elementów
    for i in range(k):
      avgs=[0.0]*len(rows[0])
      if len(bestmatches[i])>0:
        for rowid in bestmatches[i]:
          for m in range(len(rows[rowid])):
            avgs[m]+=rows[rowid][m]
        for j in range(len(avgs)):
          avgs[j]/=len(bestmatches[i])
        clusters[i]=avgs
      
  return bestmatches

def tanamoto(v1,v2):
  c1,c2,shr=0,0,0
  
  for i in range(len(v1)):
    if v1[i]!=0: c1+=1 # in v1
    if v2[i]!=0: c2+=1 # in v2
    if v1[i]!=0 and v2[i]!=0: shr+=1 # in both
  
  return 1.0-(float(shr)/(c1+c2-shr))

def scaledown(data,distance=pearson,rate=0.01):
  n=len(data)

  # rzeczywiste odległości między każdą parą pozycji
  realdist=[[distance(data[i],data[j]) for j in range(n)] 
             for i in range(0,n)]

  # losowe inicjowanie początkowych punktów lokalizacji na wykresie dwuwymiarowym
  loc=[[random.random(),random.random()] for i in range(n)]
  fakedist=[[0.0 for j in range(n)] for i in range(n)]
  
  lasterror=None
  for m in range(0,1000):
    # znajdowanie przewidywanych odległości
    for i in range(n):
      for j in range(n):
        fakedist[i][j]=sqrt(sum([pow(loc[i][x]-loc[j][x],2) 
                                 for x in range(len(loc[i]))]))
  
    # przemieszczanie punktów
    grad=[[0.0,0.0] for i in range(n)]
    
    totalerror=0
    for k in range(n):
      for j in range(n):
        if j==k: continue
        # Błąd jest różnicą procentową między odległościami.
        errorterm=(fakedist[j][k]-realdist[j][k])/realdist[j][k]
        
        # Każdy punkt wymaga oddalenia lub przybliżenia względem innego
        # punktu proporcjonalnie do wartości błędu punktu.
        grad[k][0]+=((loc[k][0]-loc[j][0])/fakedist[j][k])*errorterm
        grad[k][1]+=((loc[k][1]-loc[j][1])/fakedist[j][k])*errorterm

        # śledzenie całkowitego błędu
        totalerror+=abs(errorterm)
    print totalerror

    # Jeśli wynik nie będzie lepszy po przemieszczeniu punktów, nastąpi zakończenie wykonywania kodu
    if lasterror and lasterror<totalerror: break
    lasterror=totalerror
    
    # przemieszczanie każdego punktu o wynik iloczynu współczynnika uczenia i gradientu
    for k in range(n):
      loc[k][0]-=rate*grad[k][0]
      loc[k][1]-=rate*grad[k][1]

  return loc

def draw2d(data,labels,jpeg='mds2d.jpg'):
  img=Image.new('RGB',(2000,2000),(255,255,255))
  draw=ImageDraw.Draw(img)
  for i in range(len(data)):
    x=(data[i][0]+0.5)*1000
    y=(data[i][1]+0.5)*1000
    draw.text((x,y),labels[i],(0,0,0))
  img.save(jpeg,'JPEG')  
