import feedparser
import re


feedlist=['http://today.reuters.com/rss/topNews',
          'http://today.reuters.com/rss/domesticNews',
          'http://today.reuters.com/rss/worldNews',
          'http://hosted.ap.org/lineups/TOPHEADS-rss_2.0.xml',
          'http://hosted.ap.org/lineups/USHEADS-rss_2.0.xml',
          'http://hosted.ap.org/lineups/WORLDHEADS-rss_2.0.xml',
          'http://hosted.ap.org/lineups/POLITICSHEADS-rss_2.0.xml',
          'http://www.nytimes.com/services/xml/rss/nyt/HomePage.xml',
          'http://www.nytimes.com/services/xml/rss/nyt/International.xml',
          'http://news.google.com/?output=rss',
          'http://feeds.salon.com/salon/news',
          'http://www.foxnews.com/xmlfeed/rss/0,4313,0,00.rss',
          'http://www.foxnews.com/xmlfeed/rss/0,4313,80,00.rss',
          'http://www.foxnews.com/xmlfeed/rss/0,4313,81,00.rss',
          'http://rss.cnn.com/rss/edition.rss',
          'http://rss.cnn.com/rss/edition_world.rss',
          'http://rss.cnn.com/rss/edition_us.rss']

def stripHTML(h):
  p=''
  s=0
  for c in h:
    if c=='<': s=1
    elif c=='>':
      s=0
      p+=' '
    elif s==0: p+=c
  return p


def separatewords(text):
  splitter=re.compile('\\W*')
  return [s.lower() for s in splitter.split(text) if len(s)>3]

def getarticlewords():
  allwords={}
  articlewords=[]
  articletitles=[]
  ec=0
  # wykonanie pętli dla każdego kanału informacyjnego
  for feed in feedlist:
    f=feedparser.parse(feed)
    
    # wykonanie pętli dla każdego artykułu
    for e in f.entries:
      # zignorowanie identycznych artykułów
      if e.title in articletitles: continue
      
      # wyodrębnianie wyrazów
      txt=e.title.encode('utf8')+stripHTML(e.description.encode('utf8'))
      words=separatewords(txt)
      articlewords.append({})
      articletitles.append(e.title)
      
      # zwiększanie liczby wystąpień danego wyrazu w zmiennych allwords i articlewords
      for word in words:
        allwords.setdefault(word,0)
        allwords[word]+=1
        articlewords[ec].setdefault(word,0)
        articlewords[ec][word]+=1
      ec+=1
  return allwords,articlewords,articletitles

def makematrix(allw,articlew):
  wordvec=[]
  
  # Pobierane są tylko wspólne wyrazy, które jednak nie występują aż tak często
  for w,c in allw.items():
    if c>3 and c<len(articlew)*0.6:
      wordvec.append(w) 
  
  # tworzenie macierzy wyrazów
  l1=[[(word in f and f[word] or 0) for word in wordvec] for f in articlew]
  return l1,wordvec

from numpy import *

def showfeatures(w,h,titles,wordvec,out='features.txt'): 
  outfile=file(out,'w')  
  pc,wc=shape(h)
  toppatterns=[[] for i in range(len(titles))]
  patternnames=[]
  
  # wykonanie pętli dla wszystkich właściwości
  for i in range(pc):
    slist=[]
    # tworzenie listy wyrazów i ich wag
    for j in range(wc):
      slist.append((h[i,j],wordvec[j]))
    # odwrotne sortowanie listy wyrazów
    slist.sort()
    slist.reverse()
    
    # wyświetlenie pierwszych sześciu elementów
    n=[s[1] for s in slist[0:6]]
    outfile.write(str(n)+'\n')
    patternnames.append(n)
    
    # tworzenie listy artykułów dla danej właściwości
    flist=[]
    for j in range(len(titles)):
      # dodanie artykułu z jego wagą
      flist.append((w[j,i],titles[j]))
      toppatterns[j].append((w[j,i],i,titles[j]))
    
    # odwrotne sortowanie listy
    flist.sort()
    flist.reverse()
    
    # wyświetlenie pierwszych trzech artykułów
    for f in flist[0:3]:
      outfile.write(str(f)+'\n')
    outfile.write('\n')

  outfile.close()
  # zwrócenie nazw wzorców w celu późniejszego użycia
  return toppatterns,patternnames

def showarticles(titles,toppatterns,patternnames,out='articles.txt'):
  outfile=file(out,'w')  
  
  # wykonanie pętli dla wszystkich artykułów
  for j in range(len(titles)):
    outfile.write(titles[j].encode('utf8')+'\n')
    
    # uzyskanie dla danego artykułu najwyżej umieszczonych właściwości i 
    # posortowanie ich w odwrotnej kolejności
    toppatterns[j].sort()
    toppatterns[j].reverse()
    
    # wyświetlenie pierwszych trzech wzorców
    for i in range(3):
      outfile.write(str(toppatterns[j][i][0])+' '+
                    str(patternnames[toppatterns[j][i][1]])+'\n')
    outfile.write('\n')
    
  outfile.close()
