#include <iostream>
#include <string_view>
#include <string>

#include "pngwriter.h"

void create_flag(int const width, int const height, std::string_view filepath)
{
   pngwriter flag{ width, height, 0, filepath.data() };

   int const size = height / 2;

   // szara ramka
   flag.filledsquare(0, 0, width, height, 256, 256, 256);
   // czerwony prostokt 
   flag.filledsquare(2, 2, width - 1, size, 65535, 0, 0);
   // biay prostokt 
   flag.filledsquare(2, size + 1, width - 1, 2 * size - 1, 65535, 65535, 65535);

   flag.close();
}

int main()
{
   setlocale(LC_ALL, "polish");

   int width = 0, height = 0;
   std::string filepath;

   std::cout << "Szeroko: "; 
   std::cin >> width;

   std::cout << "Wysoko: ";
   std::cin >> height;

   std::cout << "Nazwa pliku wyjciowego: ";
   std::cin >> filepath;

   create_flag(width, height, filepath);
}
