
# coding: utf-8

## MongoDB and Python with PyMongo

# The IPython Notebook shows example code for working with MongoDB, a document database, with Python using the PyMongo package.
# 
# Before running this notebook, install both MongoDB and PyMongo. Installation instructions are available at:
# 
# http://docs.mongodb.org/manual/installation/
# MongoDB installation instructions for multiple platforms
# 
# and
# 
# 
# http://api.mongodb.org/python/current/installation.html
# Install PyMongo, a Python API for MongoDB
# 
# Start the MongoDB server using the MongoDB daemon. On Linux and Mac OS X, this typically requires a command such as:
# /mongodb/bin/mongod

# In[58]:

import pymongo     # Make PyMongo API available to this script


# Connect to the default database. If the following command generates an error, 
# 1. make sure the MongoDB server is running accoording to MongoDB instructions (see http://docs.mongodb.org/manual/installation) and
# 2. the MongoDB server is using the default network port (27017) on the localhost. See MongoDB documentation for more details.

# In[59]:

conn=pymongo.MongoClient()   


# Now that you have a connection, create a database. The following command creates a database called
# nosql-fmm-db in the MongoDB server.  Note, if the nosql-fmm-db exists, the command connects to it. If the database does not exist, it is created.

# In[60]:

db = conn ['nosql-fmm-db']


# Verify the database is avaialble on the MongoDB server by displaying database information.

# In[61]:

db


# Create a collection to store documents about customer orders.

# In[62]:

customers = db.customers


# Verify customers collection exists by displaying collection information

# In[63]:

customers


# Create an example customer to insert into database

# In[64]:

customer1 = {"custID" : "LJones788",
            "shipToStreet" : "4094 NE 38th Ave",
            "shipToCity": "Portland",
            "shipToState": "OR",
            "shipToZip": "97111"
            }


# Verify customer document exits by displaying informaiton about document

# In[65]:

customer1


# Insert customer document into customers collection

# In[66]:

customers.insert(customer1)


# Verify customer document inserted correctly

# In[67]:

customers.find_one()


# Delete customer record from collection

# In[68]:

customers.remove({'custID': 'LJones788'})


# In[ ]:



