
# coding: utf-8

## Redis with Python using Redis-Py

# The IPython Notebook shows example code for working with Redis, a key value database, with Python using the Redis-Py package.
# 
# Before running this notebook, install both Redis and Redis-Py. Installation instructions are available at:
# 
# http://redis.io/topics/quickstart
# Redis installation instructions for multiple platforms
# 
# and
# 
# https://pypi.python.org/pypi/redis/
# Install Redis-Py, a Python API for Redis
# 
# Start the Redis server using a command such as 
# 
# redis-server
# 
# See the Redis documentation for details.

# In[31]:

import redis # Make Redis API available to this script


# Create a connection to the Redis serer. 

# Connect to the default database. If the following command generates an error,
# 1. make sure the Redis server is running accoording to Redis instructions (see http://redis.io/documentation) and
# 2. the Redis server is using the default network port (6379) on the localhost. See Redis documentation for more details.

# In[32]:

rdb = redis.StrictRedis()


# 
# Now that you have a connection, add key value pairs to the database.

# In[33]:

rdb.set("custName","Lucinda Jones")


# In[34]:

rdb.set("custAddr","123 SE Main St")
rdb.set("custCity","Seattle")
rdb.set("custState","WA")


# Retrieve two values by their keys

# In[35]:

rdb.get("custName")


# In[36]:

rdb.get("custAddr")


# Delete one key value pair

# rdb.delete("custAddr")

# Verify deleted key value pair is removed

# In[37]:

rdb.get("custAddr")


# Verify other key value pairs exist

# In[38]:

rdb.get("custName")


# In[39]:

rdb.get("custCity")


# In[40]:

rdb.get("custState")

