
# coding: utf-8

## Cassndra and Python with DataStax Driver

# The IPython Notebook shows example code for working with Cassandra, a column family database, with Python using the DataStax Python drive package.
# 
# Before running this notebook, install both Cassandra and the Python drive. Installation instructions are available at:
# 
# http://planetcassandra.org/cassandra/
# Cassnadra installation instructions for multiple platforms
# 
# and
# 
# https://github.com/datastax/python-driver
# Install DataStax Python driver
# 
# Start the Cassandra server using the MongoDB daemon. On Linux and Mac OS X, this typically requires a command such as:
# /dsc-cassandra-2.0.14/bin/cassandra

# In[1]:

from cassandra.cluster import Cluster


# Connect to the default database. If the following command generates an error, 
# 1. make sure the Cassndra server is running accoording to Cassandra instructions (see http://docs.datastax.com/en/cassandra/2.0/cassandra/gettingStartedCassandraIntro.html) and
# 2. the Cassandra server is using the default network port (27017) on the localhost. See Cassandra documentation for more details.

# In[2]:

cluster = Cluster()
session = cluster.connect()


# CNow that you have a connection, create a database. The following command creates a keysspace called nosqlfmmdb in the Cassandra server. 

# In[3]:

session.execute("""CREATE KEYSPACE nosqlfmmdb WITH replication = {'class':'SimpleStrategy', 'replication_factor':1}""")


# Connect to the keyspace.

# In[3]:

nosql_fmm_db_session = cluster.connect('nosqlfmmdb')


# Create a table to store attributes about customers

# In[4]:

nosql_fmm_db_session.execute("""CREATE TABLE customers (custid int, firstname text, lastname text, addr text, city text, state text, PRIMARY KEY (custid))""")


# Insert customer record.

# In[5]:

session.execute("""insert into nosqlfmmdb.customers (custid, firstname, lastname, addr, city, state) values (12345, 'Marion','Washington', '487 Belmont Ave', 'Austin', 'TX')""")


# Verify customer inserted correctly

# In[6]:

result = nosql_fmm_db_session.execute("select * from customers")


# In[7]:

result


# In[7]:




# In[ ]:



