package streams;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;

public class LazyStreams {

    public static int multByTwo(int n) {
        System.out.printf("Wewntrz multByTwo z arg %d%n", n);
        return n * 2;
    }

    public static boolean divByThree(int n) {
        System.out.printf("Wewntrz divByThree z arg %d%n", n);
        return n % 3 == 0;
    }

    public static void main(String[] args) {
        // znajduje pirwsz parzyst liczb w przedziale od 200 do 400 podzieln przez 3
        int firstEvenDoubleDivBy3 = IntStream.range(100, 200)
                .map(n -> n * 2)
                .filter(n -> n % 3 == 0)
                .findFirst().orElse(0);
        System.out.println(firstEvenDoubleDivBy3);

        // demonstracja leniwego wykonywania na przykadzie instrukcji drukowania
        firstEvenDoubleDivBy3 = IntStream.range(100, 2_000_000)
                //.parallel()
                .map(LazyStreams::multByTwo)
                .filter(LazyStreams::divByThree)
                .findFirst().orElse(0);
        System.out.printf("Pierwsza parzysta liczba podzielna przez 3 to %d%n", firstEvenDoubleDivBy3);
/*
        Set<String> strings = new HashSet<>();
        strings.add("one");
        strings.add("two");
        strings.add("three");
        strings.add("four");
        strings.add("five");

        String str = strings.stream()
                .filter(s -> s.length() % 2 == 0)
                .findFirst().orElse("");
        System.out.println(str); */
    }
}
